/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LossyEncodingInspection");
    private static final LocalQuickFix CHANGE_ENCODING_FIX = new ChangeEncodingFix();
    private static final LocalQuickFix RELOAD_ENCODING_FIX = new ReloadInAnotherEncodingFix();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string2 = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getGroupDisplayName"));
        }
        return string2;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string2 = InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getDisplayName"));
        }
        return string2;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("LossyEncoding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getShortName"));
        }
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkFile"));
        }
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text2 = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text2);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList descriptors = new SmartList();
        boolean ok = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile, charset, (List<ProblemDescriptor>)descriptors);
        if (ok) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text2, charset, (List<ProblemDescriptor>)descriptors);
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (FileDocumentManager.getInstance().isFileModified(virtualFile) || EncodingUtil.checkCanReload((VirtualFile)virtualFile).second != null) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile, charset)) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, "File was loaded in the wrong encoding: '" + charset + "'", RELOAD_ENCODING_FIX, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
            return false;
        }
        return true;
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean equals;
        byte[] bytesToSave;
        byte[] loadedBytes;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInspection/LossyEncodingInspection", "isGoodCharset"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "isGoodCharset"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e2) {
            return true;
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        if (!(equals = Arrays.equals(bytesToSave, loadedBytes)) && LOG.isDebugEnabled()) {
            try {
                String tempDir = FileUtil.getTempDirectory();
                FileUtil.writeToFile((File)new File(tempDir, "lossy-bytes-to-save"), (byte[])bytesToSave);
                FileUtil.writeToFile((File)new File(tempDir, "lossy-loaded-bytes"), (byte[])loadedBytes);
                LOG.debug("lossy bytes dumped into " + tempDir);
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        return equals;
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text2, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        int errorCount = 0;
        int start2 = -1;
        CharBuffer buffer = CharBuffer.wrap(text2);
        for (int i2 = 0; i2 <= text2.length(); ++i2) {
            int end;
            char c2 = i2 >= text2.length() ? (char)'\u0000' : text2.charAt(i2);
            int n2 = end = Character.isHighSurrogate(c2) && i2 < text2.length() - 1 ? i2 + 2 : i2 + 1;
            if (i2 == text2.length() || LossyEncodingInspection.isRepresentable(buffer, i2, end, charset)) {
                if (start2 != -1) {
                    TextRange range = new TextRange(start2, i2);
                    String message2 = InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset});
                    ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file2, range, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{CHANGE_ENCODING_FIX});
                    descriptors.add(descriptor2);
                    start2 = -1;
                    if (errorCount++ > 200) {
                        break;
                    }
                }
            } else if (start2 == -1) {
                start2 = i2;
            }
            if (end == i2 + 1) continue;
            ++i2;
        }
    }

    private static boolean isRepresentable(@NotNull CharBuffer srcBuffer, int start2, int end, @NotNull Charset charset) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcBuffer", "com/intellij/codeInspection/LossyEncodingInspection", "isRepresentable"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "isRepresentable"));
        }
        srcBuffer.position(start2);
        srcBuffer.limit(end);
        ByteBuffer out = charset.encode(srcBuffer);
        CharBuffer buffer = charset.decode(out);
        srcBuffer.position(start2);
        return buffer.equals(srcBuffer);
    }

    private static class ChangeEncodingFix
    implements LocalQuickFix {
        private ChangeEncodingFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Change file encoding" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "getFamilyName"));
            }
            return "Change file encoding";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Editor editor;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "applyFix"));
            }
            PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            DataContext dataContext = ChangeEncodingFix.createDataContext(editor, (editor = PsiUtilBase.findEditor((PsiElement)psiFile)) == null ? null : editor.getComponent(), virtualFile, project2);
            ListPopup popup2 = new ChangeFileEncodingAction().createPopup(dataContext);
            if (popup2 != null) {
                popup2.showInBestPositionFor(dataContext);
            }
        }

        @NotNull
        static DataContext createDataContext(Editor editor, Component component, VirtualFile selectedFile, Project project2) {
            DataContext parent = DataManager.getInstance().getDataContext(component);
            DataContext context2 = SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent);
            DataContext projectContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project2, context2);
            DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), selectedFile, projectContext);
            if (dataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "createDataContext"));
            }
            return dataContext;
        }
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        private ReloadInAnotherEncodingFix() {
        }

        @NotNull
        public String getName() {
            if ("Reload in another encoding" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "getName"));
            }
            return "Reload in another encoding";
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "applyFix"));
            }
            if (FileDocumentManager.getInstance().isFileModified(descriptor2.getPsiElement().getContainingFile().getVirtualFile())) {
                return;
            }
            super.applyFix(project2, descriptor2);
        }
    }
}

