/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileFilterPanel {
    private JCheckBox myUseFileMask;
    private JComboBox myFileMask;
    private JPanel myPanel;

    FileFilterPanel() {
        this.$$$setupUI$$$();
    }

    void init(final AnalysisUIOptions options) {
        FindDialog.initFileFilter(this.myFileMask, this.myUseFileMask);
        this.myUseFileMask.setSelected(StringUtil.isNotEmpty((String)options.FILE_MASK));
        this.myFileMask.setEnabled(StringUtil.isNotEmpty((String)options.FILE_MASK));
        this.myFileMask.setSelectedItem(options.FILE_MASK);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                options.FILE_MASK = FileFilterPanel.this.myUseFileMask.isSelected() ? (String)FileFilterPanel.this.myFileMask.getSelectedItem() : null;
            }
        };
        this.myUseFileMask.addActionListener(listener2);
        this.myFileMask.addActionListener(listener2);
    }

    @Nullable
    GlobalSearchScope getSearchScope() {
        if (!this.myUseFileMask.isSelected()) {
            return null;
        }
        String text2 = (String)this.myFileMask.getSelectedItem();
        if (text2 == null) {
            return null;
        }
        final Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(text2);
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/actions/FileFilterPanel$2", "contains"));
                }
                return patternCondition.value((Object)file2.getNameSequence());
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/codeInspection/actions/FileFilterPanel$2", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/codeInspection/actions/FileFilterPanel$2", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/codeInspection/actions/FileFilterPanel$2", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseFileMask = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/FindBundle").getString("find.filter.file.mask.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myFileMask = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/FindBundle").getString("find.filter.file.name.group"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

