/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.actions.InspectionListCellRenderer;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GotoInspectionModel
extends SimpleChooseByNameModel {
    private static final InspectionToolWrapper[] EMPTY_WRAPPERS_ARRAY = new InspectionToolWrapper[0];
    private final Map<String, InspectionToolWrapper> myToolNames;
    private final String[] myNames;
    private final InspectionListCellRenderer myListCellRenderer;

    public GotoInspectionModel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/GotoInspectionModel", "<init>"));
        }
        super(project2, IdeBundle.message((String)"prompt.goto.inspection.enter.name", (Object[])new Object[0]), "goto.inspection.help.id");
        this.myToolNames = new HashMap<String, InspectionToolWrapper>();
        this.myListCellRenderer = new InspectionListCellRenderer();
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance().getCurrentProfile();
        for (ScopeToolState state : rootProfile.getAllTools()) {
            InspectionToolWrapper tool = LocalInspectionToolWrapper.findTool2RunInBatch(project2, null, rootProfile, state.getTool());
            if (tool == null) continue;
            String name = tool.getDisplayName() + " " + StringUtil.join((String[])tool.getGroupPath(), (String)" ");
            this.myToolNames.put(name, tool);
        }
        this.myNames = ArrayUtil.toStringArray(this.myToolNames.keySet());
    }

    public ListCellRenderer getListCellRenderer() {
        return this.myListCellRenderer;
    }

    @Override
    public String[] getNames() {
        return this.myNames;
    }

    @Override
    public Object[] getElementsByName(String name, String pattern) {
        InspectionToolWrapper tool = this.myToolNames.get(name);
        if (tool == null) {
            return EMPTY_WRAPPERS_ARRAY;
        }
        return new InspectionToolWrapper[]{tool};
    }

    public String getElementName(Object element) {
        if (element instanceof InspectionToolWrapper) {
            InspectionToolWrapper entry = (InspectionToolWrapper)element;
            return entry.getDisplayName() + " " + StringUtil.join((String[])entry.getGroupPath(), (String)" ");
        }
        return null;
    }
}

