/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(RunInspectionIntention.class);
    private final String myShortName;

    public RunInspectionIntention(HighlightDisplayKey key) {
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        String string2 = InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "getText"));
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = this.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "getFamilyName"));
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionIntention", "isAvailable"));
        }
        return LocalInspectionToolWrapper.findTool2RunInBatch(project2, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionIntention", "invoke"));
        }
        Module module2 = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project2);
        if (file2 != null) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(file2);
            }
        }
        RunInspectionIntention.selectScopeAndRunInspection(this.myShortName, analysisScope, module2, (PsiElement)file2, project2);
    }

    public static void selectScopeAndRunInspection(@NotNull String toolShortName, @NotNull AnalysisScope customScope, @Nullable Module module2, @Nullable PsiElement context2, @NotNull Project project2) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/actions/RunInspectionIntention", "selectScopeAndRunInspection"));
        }
        if (customScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customScope", "com/intellij/codeInspection/actions/RunInspectionIntention", "selectScopeAndRunInspection"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionIntention", "selectScopeAndRunInspection"));
        }
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project2, customScope, module2 != null ? module2.getName() : null, true, AnalysisUIOptions.getInstance(project2), context2);
        if (!dlg.showAndGet()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project2);
        customScope = dlg.getScope(uiOptions, customScope, project2, module2);
        InspectionToolWrapper wrapper = LocalInspectionToolWrapper.findTool2RunInBatch(project2, context2, toolShortName);
        LOG.assertTrue(wrapper != null, (Object)("Can't find tool with name = \"" + toolShortName + "\""));
        RunInspectionIntention.rerunInspection(wrapper, (InspectionManagerEx)InspectionManager.getInstance((Project)project2), customScope, context2);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        if (managerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerEx", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope);
    }

    @NotNull
    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "createContext"));
        }
        if (managerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerEx", "com/intellij/codeInspection/actions/RunInspectionIntention", "createContext"));
        }
        InspectionProfileImpl model2 = RunInspectionIntention.createProfile(toolWrapper, managerEx, psiElement);
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext(false);
        inspectionContext.setExternalProfile(model2);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "createContext"));
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public static InspectionProfileImpl createProfile(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "createProfile"));
        }
        if (managerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerEx", "com/intellij/codeInspection/actions/RunInspectionIntention", "createProfile"));
        }
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance().getCurrentProfile();
        LinkedHashSet allWrappers = new LinkedHashSet();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, managerEx.getProject());
        List<Object> toolWrappers = allWrappers.size() == 1 ? Collections.singletonList(allWrappers.iterator().next()) : new ArrayList(allWrappers);
        InspectionProfileImpl model2 = InspectionProfileKt.createSimple(toolWrapper.getDisplayName(), managerEx.getProject(), toolWrappers);
        try {
            Element element = new Element("toCopy");
            for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
                inspectionToolWrapper.getTool().writeSettings(element);
                InspectionToolWrapper tw = psiElement == null ? model2.getInspectionTool(inspectionToolWrapper.getShortName(), managerEx.getProject()) : model2.getInspectionTool(inspectionToolWrapper.getShortName(), psiElement);
                tw.getTool().readSettings(element);
            }
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            // empty catch block
        }
        model2.setSingleTool(toolWrapper.getShortName());
        InspectionProfileImpl inspectionProfileImpl = model2;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "createProfile"));
        }
        return inspectionProfileImpl;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

