/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public abstract class InspectionElementsMergerBase
extends InspectionElementsMerger {
    protected Element writeOldSettings(String sourceToolName) throws WriteExternalException {
        Element sourceElement = new Element("inspection_tool");
        sourceElement.setAttribute("class", sourceToolName);
        sourceElement.setAttribute("enabled", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        sourceElement.setAttribute("level", this.getDefaultSeverityLevel(sourceToolName));
        sourceElement.setAttribute("enabled_by_default", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        return sourceElement;
    }

    protected String getDefaultSeverityLevel(String sourceToolName) {
        return HighlightSeverity.WARNING.getName();
    }

    protected boolean isEnabledByDefault(String sourceToolName) {
        return true;
    }

    protected static String getMergedMarkerName(String toolName) {
        return toolName + "Merged";
    }

    protected boolean markSettingsMerged(Map<String, Element> inspectionsSettings) {
        Element merge = this.merge(inspectionsSettings, true);
        if (merge != null) {
            Element defaultElement = this.merge(Collections.emptyMap(), true);
            return !JDOMUtil.areElementsEqual((Element)merge, (Element)defaultElement);
        }
        return false;
    }

    protected boolean areSettingsMerged(Map<String, Element> inspectionsSettings, Element inspectionElement) {
        Element merge = this.merge(inspectionsSettings, true);
        return merge != null && JDOMUtil.areElementsEqual((Element)merge, (Element)inspectionElement);
    }

    protected Element merge(Map<String, Element> inspectionElements) {
        return this.merge(inspectionElements, false);
    }

    protected Element merge(Map<String, Element> inspectionElements, boolean includeDefaults) {
        LinkedHashMap scopes = null;
        ArrayList<Element> content2 = null;
        boolean enabled = false;
        String level = null;
        for (String sourceToolName : this.getSourceToolNames()) {
            Element sourceElement = inspectionElements.get(sourceToolName);
            if (sourceElement == null) {
                if (includeDefaults) {
                    try {
                        sourceElement = this.writeOldSettings(sourceToolName);
                    }
                    catch (WriteExternalException writeExternalException) {}
                } else {
                    enabled |= this.isEnabledByDefault(sourceToolName);
                    if (level == null) {
                        level = this.getDefaultSeverityLevel(sourceToolName);
                    }
                }
            }
            if (sourceElement == null) continue;
            if (content2 == null) {
                content2 = new ArrayList<Element>();
                scopes = new LinkedHashMap();
            }
            InspectionElementsMergerBase.collectContent(sourceElement, content2, scopes);
            enabled |= Boolean.parseBoolean(sourceElement.getAttributeValue("enabled"));
            if (level != null) continue;
            level = InspectionElementsMergerBase.getLevel(sourceElement);
        }
        if (content2 != null && !content2.isEmpty()) {
            Element toolElement = new Element("inspection_tool");
            toolElement.setAttribute("class", this.getMergedToolName());
            toolElement.setAttribute("enabled", String.valueOf(enabled));
            if (level != null) {
                toolElement.setAttribute("level", level);
            }
            toolElement.setAttribute("enabled_by_default", String.valueOf(enabled));
            for (Element scopeEl : scopes.values()) {
                toolElement.addContent(scopeEl);
            }
            for (Element element : content2) {
                toolElement.addContent(element);
            }
            return toolElement;
        }
        return null;
    }

    private static String getLevel(Element element) {
        return element != null ? element.getAttributeValue("level") : HighlightSeverity.WARNING.getName();
    }

    protected static void collectContent(Element sourceElement, List<Element> options, Map<String, Element> scopes) {
        if (sourceElement != null) {
            for (Element element : sourceElement.getChildren()) {
                if ("scope".equals(element.getName())) {
                    String scopeName = element.getAttributeValue("name");
                    if (scopes.containsKey(scopeName)) {
                        Element scopeElement = scopes.get(scopeName);
                        for (Element scopeEl : element.getChildren()) {
                            scopeElement.addContent(scopeEl.clone());
                        }
                        continue;
                    }
                    scopes.put(scopeName, element.clone());
                    continue;
                }
                options.add(element.clone());
            }
        }
    }

    public static class InspectionElementsMergerDelegate
    extends InspectionElementsMergerBase {
        private final InspectionElementsMerger myMerger;

        public InspectionElementsMergerDelegate(InspectionElementsMerger merger) {
            this.myMerger = merger;
        }

        public String getMergedToolName() {
            return this.myMerger.getMergedToolName();
        }

        public String[] getSourceToolNames() {
            return this.myMerger.getSourceToolNames();
        }
    }
}

