/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();
    private GlobalInspectionContextImpl myGlobalInspectionContext;

    public InspectionManagerEx(final Project project2) {
        super(project2);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                ContentManager contentManager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project2);
                if (contentManager == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$1", "compute"));
                }
                return contentManager;
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                final ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final String PREFIX = "of ";

                    public void contentAdded(ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    public void contentRemoved(ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    private void handleContentSizeChanged() {
                        int count = contentManager.getContentCount();
                        if (count == 1) {
                            Content content2 = contentManager.getContent(0);
                            String displayName = content2.getDisplayName();
                            if (!content2.getDisplayName().startsWith(PREFIX)) {
                                content2.setDisplayName(PREFIX + displayName);
                            }
                        } else if (count > 1) {
                            for (Content content3 : contentManager.getContents()) {
                                if (!content3.getDisplayName().startsWith(PREFIX)) continue;
                                content3.setDisplayName(content3.getDisplayName().substring(PREFIX.length()));
                            }
                        }
                    }
                });
                ContentManager contentManager2 = contentManager;
                if (contentManager2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$2", "compute"));
                }
                return contentManager2;
            }
        };
    }

    @Nullable
    public static SuppressIntentionAction[] getSuppressActions(@NotNull InspectionToolWrapper toolWrapper) {
        Language language;
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionManagerEx", "getSuppressActions"));
        }
        InspectionProfileEntry tool = toolWrapper.getTool();
        if (tool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)tool).getSuppressActions(null);
        }
        ArrayList<SuppressQuickFix> actions2 = new ArrayList<SuppressQuickFix>(Arrays.asList(tool.getBatchSuppressActions(null)));
        if (actions2.isEmpty() && (language = Language.findLanguageByID((String)toolWrapper.getLanguage())) != null) {
            List suppressors = LanguageInspectionSuppressors.INSTANCE.allForLanguage(language);
            for (InspectionSuppressor suppressor : suppressors) {
                SuppressQuickFix[] suppressActions = suppressor.getSuppressActions(null, toolWrapper.getID());
                Collections.addAll(actions2, suppressActions);
            }
        }
        return (SuppressIntentionAction[])ContainerUtil.map2Array(actions2, SuppressIntentionAction.class, fix -> SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)fix));
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        return problemDescriptorImpl;
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl inspectionContext;
        if (reuse) {
            if (this.myGlobalInspectionContext == null) {
                this.myGlobalInspectionContext = inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
            } else {
                inspectionContext = this.myGlobalInspectionContext;
            }
        } else {
            inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        }
        this.myRunningContexts.add(inspectionContext);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "createNewGlobalContext"));
        }
        return globalInspectionContextImpl;
    }

    public void setProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/InspectionManagerEx", "setProfile"));
        }
        this.myCurrentProfileName = name;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/intellij/codeInspection/ex/InspectionManagerEx", "closeRunningContext"));
        }
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        Set<GlobalInspectionContextImpl> set2 = this.myRunningContexts;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "getRunningContexts"));
        }
        return set2;
    }

    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        NotNullLazyValue<ContentManager> notNullLazyValue = this.myContentManager;
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "getContentManager"));
        }
        return notNullLazyValue;
    }
}

