/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixWrapper
extends QuickFixAction {
    private final QuickFix myFix;

    public LocalQuickFixWrapper(@NotNull QuickFix fix, @NotNull InspectionToolWrapper toolWrapper) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "<init>"));
        }
        super(fix.getName(), toolWrapper);
        this.myFix = fix;
        this.setText(StringUtil.escapeMnemonics((String)this.myFix.getName()));
    }

    public void setText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "setText"));
        }
        this.getTemplatePresentation().setText(text2);
    }

    @Override
    protected boolean isProblemDescriptorsAcceptable() {
        return true;
    }

    @NotNull
    public QuickFix getFix() {
        QuickFix quickFix = this.myFix;
        if (quickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "getFix"));
        }
        return quickFix;
    }

    @Nullable
    private QuickFix getWorkingQuickFix(@NotNull QuickFix[] fixes) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "getWorkingQuickFix"));
        }
        for (QuickFix fix : fixes) {
            if (!fix.getFamilyName().equals(this.myFix.getFamilyName())) continue;
            return fix;
        }
        return null;
    }

    @Override
    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        return true;
    }

    @Override
    protected void applyFix(@NotNull Project project2, @NotNull GlobalInspectionContextImpl context2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (this.myFix instanceof BatchQuickFix) {
            ArrayList collectedElementsToIgnore = new ArrayList();
            Runnable refreshViews = () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "lambda$applyFix$0"));
                }
                if (descriptors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "lambda$applyFix$0"));
                }
                if (ignoredElements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "lambda$applyFix$0"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "lambda$applyFix$0"));
                }
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
                for (CommonProblemDescriptor descriptor2 : descriptors) {
                    this.ignore(ignoredElements, descriptor2, this.getWorkingQuickFix(descriptor2.getFixes()), context2);
                }
                RefManager refManager = context2.getRefManager();
                RefElement[] refElements = new RefElement[collectedElementsToIgnore.size()];
                int collectedElementsToIgnoreSize = collectedElementsToIgnore.size();
                for (int i2 = 0; i2 < collectedElementsToIgnoreSize; ++i2) {
                    refElements[i2] = refManager.getReference((PsiElement)collectedElementsToIgnore.get(i2));
                }
                LocalQuickFixWrapper.removeElements((RefEntity[])refElements, project2, this.myToolWrapper);
            };
            ((BatchQuickFix)this.myFix).applyFix(project2, descriptors, collectedElementsToIgnore, refreshViews);
            return;
        }
        boolean restart = false;
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            QuickFix fix;
            QuickFix[] fixes;
            if (descriptor2 == null || (fixes = descriptor2.getFixes()) == null || (fix = this.getWorkingQuickFix(fixes)) == null) continue;
            fix.applyFix(project2, descriptor2);
            restart = true;
            this.ignore(ignoredElements, descriptor2, fix, context2);
        }
        if (restart) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    @Override
    protected void performFixesInBatch(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull GlobalInspectionContextImpl context2, Set<PsiElement> ignoredElements) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "performFixesInBatch"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "performFixesInBatch"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "performFixesInBatch"));
        }
        if (this.myFix instanceof BatchQuickFix) {
            this.applyFix(project2, context2, descriptors, ignoredElements);
        } else {
            super.performFixesInBatch(project2, descriptors, context2, ignoredElements);
        }
    }

    private void ignore(@NotNull Collection<PsiElement> ignoredElements, @NotNull CommonProblemDescriptor descriptor2, @Nullable QuickFix fix, @NotNull GlobalInspectionContextImpl context2) {
        PsiElement element;
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (fix != null) {
            InspectionToolPresentation presentation = context2.getPresentation(this.myToolWrapper);
            presentation.ignoreProblem(descriptor2, fix);
        }
        if (descriptor2 instanceof ProblemDescriptor && (element = ((ProblemDescriptor)descriptor2).getPsiElement()) != null) {
            ignoredElements.add(element);
        }
    }
}

