/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class InspectionTreeHtmlExportResources {
    private static final Logger LOG = Logger.getInstance(InspectionTreeHtmlExportResources.class);

    InspectionTreeHtmlExportResources() {
    }

    static void copyInspectionReportResources(String targetDirectory) {
        InspectionTreeHtmlExportResources.copyInspectionReportResource("styles.css", targetDirectory);
        InspectionTreeHtmlExportResources.copyInspectionReportResource("script.js", targetDirectory);
    }

    private static void copyInspectionReportResource(String resourceName, String targetDirectory) {
        File resourceTargetFile = new File(targetDirectory, resourceName);
        if (!FileUtil.createIfDoesntExist((File)resourceTargetFile)) {
            LOG.error("Can't create file: " + resourceTargetFile.getAbsolutePath());
        }
        try (InputStream input = InspectionTreeHtmlExportResources.class.getClassLoader().getResourceAsStream("/inspectionReport/" + resourceName);
             FileOutputStream f2 = new FileOutputStream(resourceTargetFile);){
            FileUtil.copy((InputStream)input, (OutputStream)f2);
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
        }
    }
}

