/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.RemoveExtraClosingTagIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlExtraClosingTagInspection
extends HtmlLocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string2 = XmlBundle.message((String)"html.inspection.extra.closing.tag", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlExtraClosingTagInspection", "getDisplayName"));
        }
        return string2;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlExtraClosingTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlExtraClosingTagInspection", "getShortName"));
        }
        return "HtmlExtraClosingTag";
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlExtraClosingTagInspection", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlExtraClosingTagInspection", "checkTag"));
        }
        TextRange range = XmlTagUtil.getEndTagRange((XmlTag)tag);
        if (range != null && tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) && tag.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            holder.registerProblem((PsiElement)tag, XmlErrorMessages.message("extra.closing.tag.for.empty.element", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range.shiftRight(-tag.getTextRange().getStartOffset()), new LocalQuickFix[]{new RemoveExtraClosingTagIntentionAction()});
        }
    }
}

