/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspectionBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.ChangeTemplateDataLanguageAction;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspection
extends HtmlUnknownTagInspectionBase {
    public HtmlUnknownTagInspection() {
    }

    public HtmlUnknownTagInspection(@NonNls @NotNull String defaultValues) {
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection", "<init>"));
        }
        super(defaultValues);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return HtmlUnknownTagInspection.createOptionsPanel(this);
    }

    @NotNull
    protected static JComponent createOptionsPanel(final @NotNull HtmlUnknownElementInspection inspection) {
        if (inspection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection", "createOptionsPanel"));
        }
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel internalPanel = new JPanel(new BorderLayout());
        result2.add((Component)internalPanel, "North");
        final Ref panelRef = new Ref();
        final FieldPanel additionalAttributesPanel = new FieldPanel(null, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Messages.showTextAreaDialog((JTextField)((FieldPanel)panelRef.get()).getTextField(), (String)StringUtil.wordsToBeginFromUpperCase((String)inspection.getPanelTitle()), (String)inspection.getClass().getSimpleName(), s2 -> HtmlUnknownElementInspection.reparseProperties(s2), strings -> StringUtil.join((Collection)strings, (String)","));
            }
        }, null);
        ((JButton)additionalAttributesPanel.getComponent(1)).setIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        panelRef.set((Object)additionalAttributesPanel);
        additionalAttributesPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                Document document = e2.getDocument();
                try {
                    String text2 = document.getText(0, document.getLength());
                    if (text2 != null) {
                        inspection.updateAdditionalEntries(text2.trim());
                    }
                }
                catch (BadLocationException e1) {
                    inspection.getLogger().error((Throwable)e1);
                }
            }
        });
        final JCheckBox checkBox2 = new JCheckBox(inspection.getCheckboxTitle());
        checkBox2.setSelected(inspection.isCustomValuesEnabled());
        checkBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                boolean b2 = checkBox2.isSelected();
                if (b2 != inspection.isCustomValuesEnabled()) {
                    inspection.enableCustomValues(b2);
                    additionalAttributesPanel.setEnabled(inspection.isCustomValuesEnabled());
                }
            }
        });
        internalPanel.add((Component)checkBox2, "North");
        internalPanel.add((Component)additionalAttributesPanel, "Center");
        additionalAttributesPanel.setPreferredSize(new Dimension(150, additionalAttributesPanel.getPreferredSize().height));
        additionalAttributesPanel.setEnabled(inspection.isCustomValuesEnabled());
        additionalAttributesPanel.setText(inspection.getAdditionalEntries());
        JPanel jPanel = result2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection", "createOptionsPanel"));
        }
        return jPanel;
    }

    @Override
    @Nullable
    protected LocalQuickFix createChangeTemplateDataFix(PsiFile file2) {
        if (file2 != TemplateLanguageUtil.getTemplateFile((PsiFile)file2)) {
            return null;
        }
        FileViewProvider vp = file2.getViewProvider();
        if (vp instanceof ConfigurableTemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)vp;
            final String text2 = LangBundle.message("quickfix.change.template.data.language.text", viewProvider.getTemplateDataLanguage().getDisplayName());
            return new LocalQuickFixOnPsiElement((PsiElement)file2){

                @NotNull
                public String getText() {
                    String string2 = text2;
                    if (string2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "getText"));
                    }
                    return string2;
                }

                public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "invoke"));
                    }
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "invoke"));
                    }
                    if (startElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "invoke"));
                    }
                    if (endElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "invoke"));
                    }
                    ChangeTemplateDataLanguageAction.editSettings(project2, file2.getVirtualFile());
                }

                @Nls
                @NotNull
                public String getFamilyName() {
                    if ("Change template data language" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection$4", "getFamilyName"));
                    }
                    return "Change template data language";
                }
            };
        }
        return null;
    }
}

