/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspectionBase
extends HtmlUnknownElementInspection {
    public static final Key<HtmlUnknownElementInspection> TAG_KEY = Key.create((String)"HtmlUnknownTag");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection");

    public HtmlUnknownTagInspectionBase(@NotNull String defaultValues) {
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "<init>"));
        }
        super(defaultValues);
    }

    public HtmlUnknownTagInspectionBase() {
        this("nobr,noembed,comment,noscript,embed,script");
    }

    private static boolean isAbstractDescriptor(XmlElementDescriptor descriptor2) {
        return descriptor2 == null || descriptor2 instanceof AnyXmlElementDescriptor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string2 = XmlBundle.message((String)"html.inspections.unknown.tag", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getDisplayName"));
        }
        return string2;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getShortName"));
        }
        return "HtmlUnknownTag";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getLogger"));
        }
        return logger;
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string2 = XmlBundle.message((String)"html.inspections.unknown.tag.title", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getPanelTitle"));
        }
        return string2;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlElementDescriptor ownDescriptor;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "checkTag"));
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        XmlElementDescriptor descriptorFromContext = XmlUtil.getDescriptorFromContext(tag);
        PsiElement parent = tag.getParent();
        XmlElementDescriptor parentDescriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        XmlElementDescriptor xmlElementDescriptor = ownDescriptor = HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext) ? tag.getDescriptor() : descriptorFromContext;
        if (HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) || parentDescriptor instanceof HtmlElementDescriptorImpl && ownDescriptor instanceof HtmlElementDescriptorImpl && HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext)) {
            String name = tag.getName();
            if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                ProblemHighlightType highlightType;
                AddCustomHtmlElementIntentionAction action2 = new AddCustomHtmlElementIntentionAction(TAG_KEY, name, XmlBundle.message((String)"add.custom.html.tag", (Object[])new Object[]{name}));
                String message2 = HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) ? XmlErrorMessages.message("unknown.html.tag", name) : XmlErrorMessages.message("element.is.not.allowed.here", name);
                XmlToken startTagName = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                assert (startTagName != null);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>();
                quickfixes.add(action2);
                if (isOnTheFly) {
                    PsiFile file2 = startTagName.getContainingFile();
                    if (file2 instanceof XmlFile) {
                        quickfixes.add(XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)startTagName, "", null));
                    }
                    ContainerUtil.addIfNotNull(quickfixes, (Object)this.createChangeTemplateDataFix(file2));
                }
                if (HtmlUtil.isHtml5Tag(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag)) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                ProblemHighlightType problemHighlightType = highlightType = tag.getContainingFile().getContext() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                if (startTagName.getTextLength() > 0) {
                    holder.registerProblem((PsiElement)startTagName, message2, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
                if (endTagName != null) {
                    holder.registerProblem((PsiElement)endTagName, message2, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
            }
        }
    }

    @Nullable
    protected LocalQuickFix createChangeTemplateDataFix(PsiFile file2) {
        return null;
    }
}

