/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OfflineDescriptorResolveResult {
    private RefEntity myResolvedEntity;
    private CommonProblemDescriptor myResolvedDescriptor;

    public OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    public RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    public CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor2, @NotNull InspectionToolWrapper wrapper, @NotNull InspectionToolPresentation presentation) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "resolve"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "resolve"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "resolve"));
        }
        RefEntity element = descriptor2.getRefElement(presentation.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = (CommonProblemDescriptor)ReadAction.compute(() -> {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "lambda$resolve$0"));
            }
            if (wrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "lambda$resolve$0"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "lambda$resolve$0"));
            }
            return OfflineDescriptorResolveResult.createDescriptor(element, descriptor2, wrapper, presentation);
        });
        OfflineDescriptorResolveResult offlineDescriptorResolveResult = new OfflineDescriptorResolveResult(element, resolvedDescriptor);
        if (offlineDescriptorResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "resolve"));
        }
        return offlineDescriptorResolveResult;
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (offlineDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "createDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "createDescriptor"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "createDescriptor"));
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor2;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor2 = OfflineDescriptorResolveResult.createDescriptor(element, offlineDescriptor, localTool, presentation)) != null) {
                return descriptor2;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element);
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)presentation.getContext().getProject());
        OfflineProblemDescriptor offlineProblemDescriptor = offlineDescriptor;
        if (element instanceof RefElement) {
            ProblemDescriptor descriptor3;
            PsiElement psiElement = ((RefElement)element).getElement();
            if (psiElement != null && (descriptor3 = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> {
                if (toolWrapper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "lambda$createDescriptor$1"));
                }
                return OfflineDescriptorResolveResult.runLocalTool(psiElement, inspectionManager, offlineProblemDescriptor, (LocalInspectionToolWrapper)toolWrapper);
            }, (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor3;
            }
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        CommonProblemDescriptor descriptor4 = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor4, hints, presentation);
        if (quickFixes != null) {
            descriptor4 = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        return descriptor4;
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull InspectionManager inspectionManager, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper) {
        PsiElement[] elementsInRange;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "runLocalTool"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "runLocalTool"));
        }
        if (offlineProblemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineProblemDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "runLocalTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "runLocalTool"));
        }
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        int startOffset = psiElement.getTextRange().getStartOffset();
        int endOffset = psiElement.getTextRange().getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        PsiElementVisitor visitor2 = localTool.buildVisitor(holder, false, session2);
        localTool.inspectionStarted(session2, false);
        for (PsiElement element : elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, startOffset, endOffset)) {
            element.accept(visitor2);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list2 = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor2 : list2) {
                PsiNamedElement member = localTool.getProblemElement(descriptor2.getPsiElement());
                if (!(psiElement instanceof PsiFile) && (member == null || !member.equals(psiElement))) continue;
                if (curIdx == idx) {
                    return descriptor2;
                }
                ++curIdx;
            }
        }
        return null;
    }

    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @Nullable
    private static LocalQuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor2, List<String> hints, InspectionToolPresentation presentation) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "getFixes"));
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor2, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor2, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor2, List<LocalQuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "addFix"));
        }
        IntentionAction intentionAction = presentation.findQuickFixes(descriptor2, hint);
        if (intentionAction instanceof QuickFixWrapper) {
            fixes.add(((QuickFixWrapper)intentionAction).getFix());
        }
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper, final @Nullable RefEntity entity) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult", "createRerunGlobalToolDescriptor"));
        }
        return new CommonProblemDescriptorImpl(new QuickFix[]{new QuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string2 = "Rerun '" + wrapper.getDisplayName() + "' inspection";
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$1", "getFamilyName"));
                }
                return string2;
            }

            public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$1", "applyFix"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$1", "applyFix"));
                }
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
                }
                RunInspectionAction.runInspection(project2, wrapper.getShortName(), file2, null, psiFile);
            }
        }}, "Problem detected by global inspection '" + wrapper.getDisplayName() + "'");
    }
}

