/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;
    private final Map<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>> myResolvedDescriptor;

    public OfflineInspectionRVContentProvider(@NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> content2, @NotNull Project project2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "<init>"));
        }
        super(project2);
        this.myResolvedDescriptor = new FactoryMap<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>>(){

            @Nullable
            protected Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult> create(String key) {
                return new THashMap();
            }
        };
        this.myContent = content2;
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionToolWrapper toolWrapper) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "checkReportedProblems"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "checkReportedProblems"));
        }
        Map<String, Set<OfflineProblemDescriptor>> content2 = this.getFilteredContent(context2, toolWrapper);
        return content2 != null && !content2.values().isEmpty();
    }

    @Override
    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return Collections.singletonList(tools.getDefaultState());
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getQuickFixes"));
        }
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getQuickFixes"));
        }
        TreePath[] treePaths = tree2.getSelectionPaths();
        if (treePaths == null) {
            return QuickFixAction.EMPTY;
        }
        ArrayList selectedElements = new ArrayList();
        HashMap<RefEntity, CommonProblemDescriptor[]> actions2 = new HashMap<RefEntity, CommonProblemDescriptor[]>();
        for (TreePath selectionPath : treePaths) {
            TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), node -> {
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof OfflineProblemDescriptorNode) {
                    CommonProblemDescriptor[] commonProblemDescriptorArray;
                    if (((OfflineProblemDescriptorNode)node).isQuickFixAppliedFromView()) {
                        return true;
                    }
                    OfflineProblemDescriptorNode descriptorNode = (OfflineProblemDescriptorNode)node;
                    RefEntity element = descriptorNode.getElement();
                    selectedElements.add(element);
                    CommonProblemDescriptor[] descriptors = (CommonProblemDescriptor[])actions2.get(element);
                    CommonProblemDescriptor descriptor2 = descriptorNode.getDescriptor();
                    if (descriptor2 == null) {
                        commonProblemDescriptorArray = CommonProblemDescriptor.EMPTY_ARRAY;
                    } else {
                        CommonProblemDescriptor[] commonProblemDescriptorArray2 = new CommonProblemDescriptor[1];
                        commonProblemDescriptorArray = commonProblemDescriptorArray2;
                        commonProblemDescriptorArray2[0] = descriptor2;
                    }
                    CommonProblemDescriptor[] descriptorAsArray = commonProblemDescriptorArray;
                    actions2.put(element, descriptors == null ? descriptorAsArray : DefaultInspectionToolPresentation.mergeDescriptors(descriptors, descriptorAsArray));
                } else if (node instanceof RefElementNode) {
                    selectedElements.add(((RefElementNode)node).getElement());
                }
                return true;
            });
        }
        if (selectedElements.isEmpty()) {
            return null;
        }
        RefEntity[] selectedRefElements = selectedElements.toArray(new RefEntity[selectedElements.size()]);
        GlobalInspectionContextImpl context2 = tree2.getContext();
        InspectionToolPresentation presentation = context2.getPresentation(toolWrapper);
        return presentation.extractActiveFixes(selectedRefElements, actions2, tree2.getSelectedDescriptors());
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Map<RefEntity, CommonProblemDescriptor[]> problems) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        Map filteredContent = this.getFilteredContent(context2, toolWrapper);
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            parentNode.insertByOrder(toolNode, false);
            this.buildTree(context2, filteredContent, false, toolWrapper, descriptor2 -> {
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "lambda$appendToolNodeContent$1"));
                }
                RefEntity element = descriptor2.getRefElement(context2.getRefManager());
                return new InspectionRVContentProvider.RefEntityContainer<OfflineProblemDescriptor>(element, new OfflineProblemDescriptor[]{descriptor2}){

                    @Override
                    @Nullable
                    public String getModule() {
                        String module2 = super.getModule();
                        return module2 == null ? descriptor2.getModuleName() : module2;
                    }
                };
            }, showStructure, newChild -> {
                if (toolNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "lambda$appendToolNodeContent$2"));
                }
                toolNode.insertByOrder((InspectionTreeNode)newChild, false);
                return newChild;
            });
        }
        return toolNode;
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionToolWrapper toolWrapper) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getFilteredContent"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getFilteredContent"));
        }
        Map<String, Set<OfflineProblemDescriptor>> content2 = this.myContent.get(toolWrapper.getShortName());
        if (content2 == null) {
            return null;
        }
        if (context2.getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current = new HashMap<String, Set<OfflineProblemDescriptor>>(content2);
            content2 = null;
            InspectionToolPresentation presentation = context2.getPresentation(toolWrapper);
            for (RefEntity refEntity : presentation.getIgnoredRefElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current);
            }
            return current;
        }
        return content2;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content2) {
        Iterator<String> iter = content2.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet((Collection)content2.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content2.put(packageName, (Set<OfflineProblemDescriptor>)excluded);
        }
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container, @NotNull InspectionTreeNode packageNode, boolean canPackageRepeat) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (packageNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNode", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        InspectionToolPresentation presentation = context2.getPresentation(toolWrapper);
        RefElementNode elemNode = OfflineInspectionRVContentProvider.addNodeToParent(container, presentation, packageNode);
        for (OfflineProblemDescriptor descriptor2 : (OfflineProblemDescriptor[])container.getDescriptors()) {
            OfflineDescriptorResolveResult resolveResult = this.myResolvedDescriptor.get(toolWrapper.getShortName()).computeIfAbsent(descriptor2, d2 -> {
                if (toolWrapper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "lambda$appendDescriptor$3"));
                }
                return OfflineDescriptorResolveResult.resolve(d2, toolWrapper, presentation);
            });
            elemNode.insertByOrder((InspectionTreeNode)ReadAction.compute(() -> {
                if (toolWrapper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "lambda$appendDescriptor$4"));
                }
                return OfflineProblemDescriptorNode.create(descriptor2, resolveResult, toolWrapper, presentation);
            }), true);
        }
    }
}

