/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class InspectionTreeUpdater {
    private final MergingUpdateQueue myUpdateQueue;
    private final InspectionResultsView myView;
    private final AtomicBoolean myDoUpdatePreviewPanel = new AtomicBoolean(false);

    public InspectionTreeUpdater(InspectionResultsView view2) {
        this.myView = view2;
        this.myUpdateQueue = new MergingUpdateQueue("InspectionView", 100, true, (JComponent)view2, (Disposable)view2);
    }

    public void updateWithPreviewPanel(@Nullable TreeNode node) {
        this.myDoUpdatePreviewPanel.set(true);
        this.update(node, false);
    }

    public void update(@Nullable TreeNode node, boolean force) {
        if (ApplicationManager.getApplication().isDispatchThread() && !force) {
            return;
        }
        this.myUpdateQueue.queue((Update)new MyTreeUpdate());
    }

    private class MyTreeUpdate
    extends Update {
        public MyTreeUpdate() {
            super((Object)"inspection.view.update");
        }

        public void run() {
            if (InspectionTreeUpdater.this.myView.isDisposed()) {
                return;
            }
            InspectionTree tree2 = InspectionTreeUpdater.this.myView.getTree();
            try {
                tree2.setQueueUpdate(true);
                ((DefaultTreeModel)tree2.getModel()).reload();
                tree2.restoreExpansionAndSelection(true);
                InspectionTreeUpdater.this.myView.openRightPanelIfNeed();
                if (InspectionTreeUpdater.this.myDoUpdatePreviewPanel.compareAndSet(true, false)) {
                    InspectionTreeUpdater.this.myView.updateRightPanelLoading();
                }
            }
            finally {
                tree2.setQueueUpdate(false);
            }
        }

        public boolean canEat(Update update2) {
            return true;
        }
    }
}

