/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class InspectionViewNavigationPanel
extends JPanel
implements InspectionTreeLoadingProgressAware {
    private final InspectionTreeNode myNode;
    private final InspectionTree myTree;
    private final JPanel myLinks;
    private int myShownChildrenCount;

    public InspectionViewNavigationPanel(InspectionTreeNode node, InspectionTree tree2) {
        this.myNode = node;
        this.myTree = tree2;
        this.setLayout(new BorderLayout());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)18, (int)12, (int)0, (int)0));
        String titleLabelText = InspectionViewNavigationPanel.getTitleText(true);
        this.add((Component)new JBLabel(titleLabelText), "North");
        this.myLinks = new JPanel();
        this.myLinks.setLayout(new BoxLayout(this.myLinks, 1));
        this.add("Center", this.myLinks);
        this.resetChildrenNavigation();
    }

    @Override
    public void updateLoadingProgress() {
        this.resetChildrenAndRepaint();
    }

    @Override
    public void treeLoaded() {
        this.resetChildrenAndRepaint();
    }

    @NotNull
    public static String getTitleText(boolean addColon) {
        String string2 = "Select inspection to see problems" + (addColon ? ":" : ".");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewNavigationPanel", "getTitleText"));
        }
        return string2;
    }

    private void resetChildrenNavigation() {
        int currentChildrenCount = this.myNode.getChildCount();
        if (this.myShownChildrenCount != currentChildrenCount) {
            this.myLinks.removeAll();
            this.myLinks.add(Box.createVerticalStrut(JBUI.scale((int)10)));
            for (int i2 = 0; i2 < currentChildrenCount; ++i2) {
                final TreeNode child = this.myNode.getChildAt(i2);
                LinkLabel link = new LinkLabel(child.toString(), null){

                    public void doClick() {
                        TreeUtil.selectInTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)child), (boolean)true, (JTree)((Object)InspectionViewNavigationPanel.this.myTree));
                    }
                };
                link.setBorder(IdeBorderFactory.createEmptyBorder((int)1, (int)17, (int)3, (int)1));
                this.myLinks.add((Component)link);
            }
            this.myShownChildrenCount = currentChildrenCount;
        }
    }

    private void resetChildrenAndRepaint() {
        this.resetChildrenNavigation();
        this.revalidate();
        this.repaint();
    }
}

