/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ProblemPreviewEditorPresentation {
    private static final Logger LOG = Logger.getInstance(ProblemPreviewEditorPresentation.class);
    private static final int VIEW_ADDITIONAL_OFFSET = 4;
    private final EditorEx myEditor;
    private final InspectionResultsView myView;
    private final SortedSet<PreviewEditorFoldingRegion> myFoldedRegions = new TreeSet<PreviewEditorFoldingRegion>(Comparator.comparing(x2 -> x2.startLine));
    private final DocumentEx myDocument;

    public ProblemPreviewEditorPresentation(EditorEx editor, InspectionResultsView view2) {
        this.myEditor = editor;
        this.myView = view2;
        this.myDocument = editor.getDocument();
        this.myFoldedRegions.add(new PreviewEditorFoldingRegion(0, this.myDocument.getLineCount()));
        this.appendFoldings(view2.getTree().getAllValidSelectedDescriptors());
    }

    private static boolean inRegion(int position, PreviewEditorFoldingRegion range) {
        return range.startLine <= position && range.endLine > position;
    }

    private void appendFoldings(CommonProblemDescriptor[] descriptors) {
        List usages = Arrays.stream(descriptors).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(d2 -> {
            PsiElement psi = d2.getPsiElement();
            if (psi == null) {
                return null;
            }
            TextRange range = d2.getTextRangeInElement();
            return range == null ? new UsageInfo(psi) : new UsageInfo(psi, range.getStartOffset(), range.getEndOffset());
        }).collect(Collectors.toList());
        boolean isUpdated = false;
        for (UsageInfo usage : usages) {
            if (usage == null) {
                return;
            }
            isUpdated |= this.appendFoldings(usage.getSegment());
        }
        if (isUpdated) {
            this.updateFoldings();
        }
        List validUsages = usages.stream().filter(Objects::nonNull).collect(Collectors.toList());
        PsiDocumentManager.getInstance((Project)this.myView.getProject()).performLaterWhenAllCommitted(() -> {
            if (!this.myEditor.isDisposed()) {
                PsiElement element;
                this.myView.invalidate();
                this.myView.validate();
                UsagePreviewPanel.highlight((List)validUsages, (Editor)this.myEditor, (Project)this.myView.getProject(), (boolean)false, (int)6000);
                if (validUsages.size() == 1 && (element = ((UsageInfo)validUsages.get(0)).getElement()) != null) {
                    DocumentEx document = this.myEditor.getDocument();
                    int offset = Math.min(element.getTextRange().getEndOffset() + 4, document.getLineEndOffset(document.getLineNumber(element.getTextRange().getEndOffset())));
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offset), ScrollType.CENTER);
                    return;
                }
                this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    private void updateFoldings() {
        this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
            this.myEditor.getFoldingModel().clearFoldRegions();
            this.myEditor.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : this.myFoldedRegions) {
                FoldRegion currentRegion;
                if (region.endLine - region.startLine <= 1 || (currentRegion = FoldingModelSupport.addFolding(this.myEditor, region.startLine, region.endLine, false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter(this.myEditor, this.myDocument.getLineStartOffset(region.startLine), this.myDocument.getLineEndOffset(region.endLine - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private boolean appendFoldings(Segment toShowRange) {
        if (toShowRange == null) {
            return false;
        }
        boolean isUpdated = false;
        int startLine = Math.max(0, this.myDocument.getLineNumber(toShowRange.getStartOffset()) - 1);
        int endLine = Math.min(this.myDocument.getLineCount(), this.myDocument.getLineNumber(toShowRange.getEndOffset()) + 2);
        for (PreviewEditorFoldingRegion range : new ArrayList<PreviewEditorFoldingRegion>(this.myFoldedRegions)) {
            boolean startInRegion = ProblemPreviewEditorPresentation.inRegion(startLine, range);
            boolean endInRegion = ProblemPreviewEditorPresentation.inRegion(endLine, range);
            if (startInRegion && endInRegion) {
                this.myFoldedRegions.remove(range);
                if (range.startLine != startLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(range.startLine, startLine));
                }
                if (endLine != range.endLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(endLine, range.endLine));
                }
                return true;
            }
            if (startInRegion) {
                this.myFoldedRegions.remove(range);
                if (range.startLine != startLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(range.startLine, startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            this.myFoldedRegions.remove(range);
            if (endLine != range.endLine) {
                this.myFoldedRegions.add(new PreviewEditorFoldingRegion(endLine, range.endLine));
            }
            return true;
        }
        return isUpdated;
    }

    private static class PreviewEditorFoldingRegion {
        public final int startLine;
        public final int endLine;

        private PreviewEditorFoldingRegion(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }
}

