/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CachedInspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.RefElementAndDescriptorAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends CachedInspectionTreeNode
implements RefElementAndDescriptorAware {
    @NotNull
    private final InspectionResultsView myView;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    protected final InspectionToolPresentation myPresentation;

    protected SuppressableInspectionTreeNode(Object userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "<init>"));
        }
        super(userObject);
        this.myView = presentation.getContext().getView();
        this.myPresentation = presentation;
    }

    @Override
    @NotNull
    public InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getPresentation"));
        }
        return inspectionToolPresentation;
    }

    public boolean canSuppress() {
        return this.isLeaf();
    }

    public final boolean isAlreadySuppressedFromView() {
        Object usrObj = this.getUserObject();
        return usrObj != null && this.myView.getSuppressedNodes(this.myPresentation.getToolWrapper().getShortName()).contains(usrObj);
    }

    public abstract boolean isQuickFixAppliedFromView();

    @Override
    @Nullable
    public String getCustomizedTailText() {
        String text2 = super.getCustomizedTailText();
        if (text2 != null) {
            return text2;
        }
        return this.isAlreadySuppressedFromView() ? "Suppressed" : null;
    }

    @NotNull
    public Set<SuppressIntentionAction> getAvailableSuppressActions() {
        Set<SuppressIntentionAction> set2 = this.myAvailableSuppressActions;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getAvailableSuppressActions"));
        }
        return set2;
    }

    public void removeSuppressActionFromAvailable(@NotNull SuppressIntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "removeSuppressActionFromAvailable"));
        }
        this.myAvailableSuppressActions.remove(action2);
    }

    @Override
    protected void init(Project project2) {
        super.init(project2);
        this.myAvailableSuppressActions = this.getElement() == null ? Collections.emptySet() : this.getOnlyAvailableSuppressActions(project2);
    }

    @NotNull
    public final Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        PsiElement element = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null);
        Pair pair = Pair.create((Object)element, (Object)descriptor2);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getSuppressContent"));
        }
        return pair;
    }

    @NotNull
    private Set<SuppressIntentionAction> getOnlyAvailableSuppressActions(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
        }
        Set<SuppressIntentionAction> actions2 = this.getSuppressActions();
        if (actions2.isEmpty()) {
            Set<SuppressIntentionAction> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
            }
            return set2;
        }
        Pair<PsiElement, CommonProblemDescriptor> suppress = this.getSuppressContent();
        PsiElement suppressElement = (PsiElement)suppress.getFirst();
        if (suppressElement == null) {
            Set<SuppressIntentionAction> set3 = actions2;
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
            }
            return set3;
        }
        Set availableActions = null;
        for (SuppressIntentionAction action2 : actions2) {
            if (!action2.isAvailable(project2, null, suppressElement)) continue;
            if (availableActions == null) {
                availableActions = ContainerUtil.newConcurrentSet((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
            }
            availableActions.add(action2);
        }
        Set<Object> set4 = availableActions == null ? Collections.emptySet() : availableActions;
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
        }
        return set4;
    }

    @NotNull
    private Set<SuppressIntentionAction> getSuppressActions() {
        Set<SuppressIntentionAction> set2 = this.myView.getSuppressActions(this.myPresentation.getToolWrapper());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getSuppressActions"));
        }
        return set2;
    }
}

