/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ObjectUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public class EditSettingsAction
extends InspectionViewActionBase {
    public EditSettingsAction() {
        super(InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), AllIcons.General.Settings);
    }

    public void actionPerformed(AnActionEvent e2) {
        final InspectionResultsView view2 = EditSettingsAction.getView(e2);
        InspectionProfileImpl inspectionProfile = view2.getCurrentProfile();
        if (view2.isSingleInspectionRun()) {
            InspectionToolWrapper tool = (InspectionToolWrapper)ObjectUtils.notNull((Object)inspectionProfile.getInspectionTool((String)ObjectUtils.notNull((Object)inspectionProfile.getSingleTool()), view2.getProject()));
            JComponent panel2 = tool.getTool().createOptionsPanel();
            if (panel2 != null) {
                DialogBuilder builder = new DialogBuilder().title(InspectionsBundle.message((String)"inspection.tool.window.inspection.dialog.title", (Object[])new Object[]{tool.getDisplayName()})).centerPanel(panel2);
                builder.removeAllActions();
                builder.addOkAction();
                if (view2.isRerunAvailable()) {
                    builder.addActionDescriptor((DialogBuilder.ActionDescriptor)new DialogBuilder.DialogActionDescriptor(InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), 82){

                        protected Action createAction(final DialogWrapper dialogWrapper) {
                            return new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e2) {
                                    view2.rerun();
                                    dialogWrapper.close(0);
                                }
                            };
                        }
                    });
                }
                builder.show();
            } else {
                Messages.showInfoMessage((Project)view2.getProject(), (String)InspectionsBundle.message((String)"inspection.tool.window.dialog.no.options", (Object[])new Object[]{tool.getDisplayName()}), (String)InspectionsBundle.message((String)"inspection.tool.window.dialog.title", (Object[])new Object[0]));
            }
        } else {
            HighlightDisplayKey key;
            InspectionToolWrapper toolWrapper = view2.getTree().getSelectedToolWrapper(false);
            if (toolWrapper != null && (key = HighlightDisplayKey.find((String)toolWrapper.getShortName())) != null) {
                if (new EditInspectionToolsSettingsAction(key).editToolSettings(view2.getProject(), inspectionProfile)) {
                    view2.updateCurrentProfile();
                }
                return;
            }
            String[] path = view2.getTree().getSelectedGroupPath();
            if (EditInspectionToolsSettingsAction.editSettings(view2.getProject(), inspectionProfile, c2 -> {
                if (path != null) {
                    c2.selectInspectionGroup(path);
                }
            })) {
                view2.updateCurrentProfile();
            }
        }
    }
}

