/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyAwareInspectionViewAction
extends InspectionViewActionBase {
    private static final Logger LOG = Logger.getInstance(KeyAwareInspectionViewAction.class);

    public KeyAwareInspectionViewAction(String name) {
        super(name);
    }

    @Override
    protected boolean isEnabled(@NotNull InspectionResultsView view2, AnActionEvent e2) {
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction", "isEnabled"));
        }
        InspectionToolWrapper wrapper = view2.getTree().getSelectedToolWrapper(true);
        return wrapper != null && HighlightDisplayKey.find((String)wrapper.getShortName()) != null;
    }

    public void actionPerformed(AnActionEvent e2) {
        InspectionResultsView view2 = KeyAwareInspectionViewAction.getView(e2);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)view2.getTree().getSelectedToolWrapper(true).getShortName());
        this.actionPerformed(view2, key);
    }

    protected abstract void actionPerformed(@NotNull InspectionResultsView var1, @NotNull HighlightDisplayKey var2);

    public static class RunInspectionOn
    extends KeyAwareInspectionViewAction {
        public RunInspectionOn() {
            super(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view2, AnActionEvent e2) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "isEnabled"));
            }
            return super.isEnabled(view2, e2) && RunInspectionOn.getPsiElement(view2) != null;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view2, @NotNull HighlightDisplayKey key) {
            AnalysisScope scope;
            PsiFile context2;
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "actionPerformed"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "actionPerformed"));
            }
            THashSet files2 = new THashSet();
            for (RefEntity entity : view2.getTree().getSelectedElements()) {
                if (!(entity instanceof RefElement) || !entity.isValid()) continue;
                PsiElement element = ((RefElement)entity).getElement();
                PsiFile file2 = element.getContainingFile();
                files2.add(file2);
            }
            boolean useModule = true;
            Module module2 = null;
            for (PsiFile file3 : files2) {
                Module currentFileModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file3);
                if (currentFileModule != null) {
                    if (module2 == null) {
                        module2 = currentFileModule;
                        continue;
                    }
                    if (currentFileModule == module2) continue;
                    useModule = false;
                    break;
                }
                useModule = false;
                break;
            }
            switch (files2.size()) {
                case 0: {
                    context2 = null;
                    scope = view2.getScope();
                    break;
                }
                case 1: {
                    PsiFile theFile = (PsiFile)ContainerUtil.getFirstItem((Collection)files2);
                    LOG.assertTrue(theFile != null);
                    context2 = theFile;
                    scope = new AnalysisScope(theFile);
                    break;
                }
                default: {
                    context2 = null;
                    scope = new AnalysisScope(view2.getProject(), (Collection)files2.stream().map(PsiFile::getVirtualFile).collect(Collectors.toList()));
                }
            }
            RunInspectionIntention.selectScopeAndRunInspection(key.toString(), scope, (Module)(useModule ? module2 : null), (PsiElement)context2, view2.getProject());
        }

        @Nullable
        private static PsiElement getPsiElement(InspectionResultsView view2) {
            RefEntity[] selectedElements = view2.getTree().getSelectedElements();
            PsiElement psiElement = selectedElements.length > 0 && selectedElements[0] instanceof RefElement ? ((RefElement)selectedElements[0]).getElement() : null;
            return psiElement;
        }
    }

    public static class DisableInspection
    extends KeyAwareInspectionViewAction {
        public DisableInspection() {
            super(DisableInspectionToolAction.NAME);
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view2, AnActionEvent e2) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "isEnabled"));
            }
            boolean enabled = super.isEnabled(view2, e2);
            if (!enabled) {
                return false;
            }
            HighlightDisplayKey key = HighlightDisplayKey.find((String)view2.getTree().getSelectedToolWrapper(true).getShortName());
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(view2.getProject()).getCurrentProfile();
            return profile2.isToolEnabled(key);
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view2, @NotNull HighlightDisplayKey key) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "actionPerformed"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "actionPerformed"));
            }
            if (view2.isSingleInspectionRun()) {
                view2.getCurrentProfile().modifyProfile((Consumer<InspectionProfileModifiableModel>)((Consumer)it -> {
                    if (key == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "lambda$actionPerformed$0"));
                    }
                    if (view2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "lambda$actionPerformed$0"));
                    }
                    it.disableTool(key.toString(), view2.getProject());
                }));
                view2.updateCurrentProfile();
            } else {
                RefEntity[] selectedElements = view2.getTree().getSelectedElements();
                HashSet<PsiElement> files2 = new HashSet<PsiElement>();
                for (RefEntity selectedElement : selectedElements) {
                    if (!(selectedElement instanceof RefElement)) continue;
                    files2.add(((RefElement)selectedElement).getElement());
                }
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(view2.getProject(), (Consumer<ModifiableModel>)((Consumer)it -> {
                    if (key == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "lambda$actionPerformed$1"));
                    }
                    for (PsiElement element : files2) {
                        it.disableTool(key.toString(), element);
                    }
                }));
            }
        }
    }
}

