/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.codeInspection.ui.actions.KeyAwareInspectionViewAction;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionSequentialTask;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup
implements CompactActionGroup {
    private static final Logger LOG = Logger.getInstance(SuppressActionWrapper.class);

    public SuppressActionWrapper() {
        super(InspectionsBundle.message((String)"suppress.inspection.problem", (Object[])new Object[0]), false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        InspectionResultsView view2 = InspectionViewActionBase.getView(e2);
        if (view2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        InspectionToolWrapper wrapper = view2.getTree().getSelectedToolWrapper(true);
        if (wrapper == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Set<SuppressIntentionAction> suppressActions = view2.getSuppressActions(wrapper);
        if (suppressActions.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] actions2 = new AnAction[suppressActions.size() + 1];
        int i2 = 0;
        for (SuppressIntentionAction action2 : suppressActions) {
            actions2[i2++] = new SuppressTreeAction(action2);
        }
        actions2[suppressActions.size()] = Separator.getInstance();
        Arrays.sort(actions2, new Comparator<AnAction>(){

            @Override
            public int compare(AnAction a1, AnAction a2) {
                return this.getWeight(a1) - this.getWeight(a2);
            }

            public int getWeight(AnAction a) {
                return a instanceof Separator ? 0 : (((SuppressTreeAction)a).isSuppressAll() ? 1 : -1);
            }
        });
        if (actions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper", "getChildren"));
        }
        return actions2;
    }

    public static class SuppressTreeAction
    extends KeyAwareInspectionViewAction {
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(SuppressIntentionAction suppressAction) {
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view2, @NotNull HighlightDisplayKey key) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "actionPerformed"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "actionPerformed"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (view2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "lambda$actionPerformed$1"));
                }
                Project project2 = view2.getProject();
                String templatePresentationText = this.getTemplatePresentation().getText();
                LOG.assertTrue(templatePresentationText != null);
                InspectionToolWrapper wrapper = view2.getTree().getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper != null);
                Set<SuppressableInspectionTreeNode> nodesAsSet = this.getNodesToSuppress(view2);
                SuppressableInspectionTreeNode[] nodes = nodesAsSet.toArray(new SuppressableInspectionTreeNode[nodesAsSet.size()]);
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    if (view2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "lambda$null$0"));
                    }
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, templatePresentationText, true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask(new SuppressActionSequentialTask(nodes, this.mySuppressAction, wrapper, view2.getGlobalInspectionContext()));
                    ProgressManager.getInstance().run((Task)progressTask);
                }, templatePresentationText, null);
                Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)project2)).getRunningContexts();
                for (GlobalInspectionContextImpl context2 : globalInspectionContexts) {
                    context2.refreshViews();
                }
                view2.syncRightPanel();
            });
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view2, AnActionEvent e2) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "isEnabled"));
            }
            Set<SuppressableInspectionTreeNode> suppressNodes = this.getNodesToSuppress(view2);
            for (SuppressableInspectionTreeNode node : suppressNodes) {
                PsiElement element;
                if (!node.getAvailableSuppressActions().contains(this.mySuppressAction)) continue;
                String text2 = this.mySuppressAction.getFamilyName();
                if (suppressNodes.size() == 1 && (element = (PsiElement)node.getSuppressContent().getFirst()) != null) {
                    this.mySuppressAction.isAvailable(view2.getProject(), null, element);
                    text2 = this.mySuppressAction.getText();
                }
                e2.getPresentation().setText(text2);
                return true;
            }
            return false;
        }

        public boolean isSuppressAll() {
            return this.mySuppressAction.isSuppressAll();
        }

        private Set<SuppressableInspectionTreeNode> getNodesToSuppress(@NotNull InspectionResultsView view2) {
            if (view2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction", "getNodesToSuppress"));
            }
            TreePath[] paths = view2.getTree().getSelectionPaths();
            if (paths == null) {
                return Collections.emptySet();
            }
            HashSet result2 = new HashSet();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof TreeNode)) continue;
                TreeUtil.traverse((TreeNode)((TreeNode)node), arg_0 -> this.lambda$getNodesToSuppress$2((Set)result2, arg_0));
            }
            return result2;
        }

        private /* synthetic */ boolean lambda$getNodesToSuppress$2(Set result2, Object node1) {
            InspectionTreeNode n2 = (InspectionTreeNode)node1;
            if (n2 instanceof SuppressableInspectionTreeNode && ((SuppressableInspectionTreeNode)n2).canSuppress() && ((SuppressableInspectionTreeNode)n2).getAvailableSuppressActions().contains(this.mySuppressAction) && n2.isValid()) {
                result2.add((SuppressableInspectionTreeNode)n2);
            }
            return true;
        }
    }
}

