/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class AsyncFutureResultImpl<V>
implements AsyncFutureResult<V> {
    private final SettableFuture<V> myFuture = SettableFuture.create();

    public void addConsumer(@NotNull Executor executor2, @NotNull ResultConsumer<V> consumer2) {
        if (executor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/concurrency/AsyncFutureResultImpl", "addConsumer"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/concurrency/AsyncFutureResultImpl", "addConsumer"));
        }
        this.myFuture.addListener(() -> {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/concurrency/AsyncFutureResultImpl", "lambda$addConsumer$0"));
            }
            try {
                Object result2 = this.myFuture.get();
                consumer2.onSuccess(result2);
            }
            catch (ExecutionException e2) {
                consumer2.onFailure(e2.getCause());
            }
            catch (Throwable throwable) {
                consumer2.onFailure(throwable);
            }
        }, executor2);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.myFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.myFuture.isCancelled();
    }

    public boolean isDone() {
        return this.myFuture.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.myFuture.get();
    }

    /*
     * WARNING - void declaration
     */
    public V get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/concurrency/AsyncFutureResultImpl", "get"));
        }
        return (V)this.myFuture.get(timeout, (TimeUnit)unit);
    }

    public void set(V value2) {
        if (!this.myFuture.set(value2)) {
            throw new Error("already set");
        }
    }

    public void setException(@NotNull Throwable t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/concurrency/AsyncFutureResultImpl", "setException"));
        }
        if (!this.myFuture.setException(t2)) {
            throw new Error("already excepted");
        }
    }
}

