/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ApplierCompleter;
import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLauncherImpl
extends JobLauncher {
    static final int CORES_FORK_THRESHOLD = 1;

    @Override
    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        AbstractProgressIndicatorBase wrapper = progress == null ? new StandardProgressIndicatorBase() : new SensitiveProgressWrapper(progress);
        Boolean result2 = JobLauncherImpl.processImmediatelyIfTooFew(things, wrapper, runInReadAction, thingProcessor);
        if (result2 != null) {
            return result2;
        }
        HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        List failedSubTasks = Collections.synchronizedList(new ArrayList());
        ApplierCompleter<T> applier = new ApplierCompleter<T>(null, runInReadAction, failFastOnAcquireReadAction, wrapper, things, thingProcessor, 0, things.size(), failedSubTasks, null);
        try {
            ForkJoinPool.commonPool().invoke(applier);
            if (applier.throwable != null) {
                throw applier.throwable;
            }
        }
        catch (ApplierCompleter.ComputationAbortedException e2) {
            return false;
        }
        catch (ApplicationUtil.CannotRunReadActionException e3) {
            throw e3;
        }
        catch (ProcessCanceledException e4) {
            return false;
        }
        catch (Error | RuntimeException e5) {
            throw e5;
        }
        catch (Throwable e6) {
            throw new RuntimeException(e6);
        }
        assert (applier.isDone());
        return applier.completeTaskWhichFailToAcquireReadAction();
    }

    private static <T> Boolean processImmediatelyIfTooFew(@NotNull List<T> things, @NotNull ProgressIndicator progress, boolean runInReadAction, @NotNull Processor<? super T> thingProcessor) {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "processImmediatelyIfTooFew"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/concurrency/JobLauncherImpl", "processImmediatelyIfTooFew"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "processImmediatelyIfTooFew"));
        }
        if (things.isEmpty()) {
            return true;
        }
        if (things.size() <= 1 || JobSchedulerImpl.CORES_COUNT <= 1 || runInReadAction && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            AtomicBoolean result2 = new AtomicBoolean(true);
            Runnable runnable2 = () -> {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "lambda$processImmediatelyIfTooFew$1"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "lambda$processImmediatelyIfTooFew$1"));
                }
                if (progress == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/concurrency/JobLauncherImpl", "lambda$processImmediatelyIfTooFew$1"));
                }
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    if (things == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "lambda$null$0"));
                    }
                    if (thingProcessor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "lambda$null$0"));
                    }
                    for (int i2 = 0; i2 < things.size(); ++i2) {
                        Object thing = things.get(i2);
                        if (thingProcessor.process(thing)) continue;
                        result2.set(false);
                        break;
                    }
                }, progress);
            };
            if (runInReadAction) {
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable2)) {
                    return false;
                }
            } else {
                runnable2.run();
            }
            return result2.get();
        }
        return null;
    }

    @Override
    @NotNull
    public <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        return asyncFuture;
    }

    @Override
    @NotNull
    public Job<Void> submitToJobThread(@NotNull Runnable action2, @Nullable Consumer<Future> onDoneCallback) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        VoidForkJoinTask task2 = new VoidForkJoinTask(action2, onDoneCallback);
        task2.submit();
        VoidForkJoinTask voidForkJoinTask = task2;
        if (voidForkJoinTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        return voidForkJoinTask;
    }

    public <T> boolean processQueue(final @NotNull BlockingQueue<T> things, final @NotNull Queue<T> failedToProcess, final @NotNull ProgressIndicator progress, final @NotNull T tombStone, final @NotNull Processor<? super T> thingProcessor) {
        class MyTask
        implements Callable<Boolean> {
            private final int mySeq;
            private boolean result;

            MyTask(int seq) {
                this.mySeq = seq;
            }

            @Override
            public Boolean call() throws Exception {
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }, progress);
                return this.result;
            }

            public String toString() {
                return super.toString() + " seq=" + this.mySeq;
            }
        }
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (failedToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedToProcess", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (tombStone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tombStone", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        boolean isSmallEnough = things.contains(tombStone);
        if (isSmallEnough) {
            try {
                return new MyTask(0).call();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
        ArrayList<Future> tasks = new ArrayList<Future>();
        for (int i2 = 0; i2 < JobSchedulerImpl.CORES_COUNT; ++i2) {
            tasks.add(ForkJoinPool.commonPool().submit((Callable)new MyTask(i2)));
        }
        boolean result2 = true;
        RuntimeException exception = null;
        for (ForkJoinTask forkJoinTask : tasks) {
            try {
                result2 &= ((Boolean)forkJoinTask.join()).booleanValue();
            }
            catch (RuntimeException e4) {
                exception = e4;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result2;
    }

    private static class VoidForkJoinTask
    implements Job<Void> {
        private final Runnable myAction;
        private final Consumer<Future> myOnDoneCallback;
        private volatile Status myStatus;
        private final ForkJoinTask<Void> myForkJoinTask;

        private VoidForkJoinTask(@NotNull Runnable action2, @Nullable Consumer<Future> onDoneCallback) {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "<init>"));
            }
            this.myForkJoinTask = new ForkJoinTask<Void>(){

                @Override
                public Void getRawResult() {
                    return null;
                }

                @Override
                protected void setRawResult(Void value2) {
                }

                @Override
                protected boolean exec() {
                    myStatus = Status.STARTED;
                    try {
                        myAction.run();
                        this.complete(null);
                    }
                    catch (Throwable throwable) {
                        this.completeExceptionally(throwable);
                    }
                    finally {
                        myStatus = Status.EXECUTED;
                        if (myOnDoneCallback != null) {
                            myOnDoneCallback.consume((Object)this);
                        }
                    }
                    return true;
                }
            };
            this.myAction = action2;
            this.myOnDoneCallback = onDoneCallback;
        }

        private void submit() {
            ForkJoinPool.commonPool().submit(this.myForkJoinTask);
        }

        @Override
        public boolean isDone() {
            boolean wasCancelled = this.myForkJoinTask.isCancelled();
            Status status = this.myStatus;
            return status == Status.EXECUTED || status == null && wasCancelled;
        }

        @Override
        public String getTitle() {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isCanceled() {
            return this.myForkJoinTask.isCancelled();
        }

        @Override
        public void addTask(@NotNull Callable<Void> task2) {
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void addTask(@NotNull Runnable task2, Void result2) {
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void addTask(@NotNull Runnable task2) {
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public List<Void> scheduleAndWaitForResults() throws Throwable {
            throw new IncorrectOperationException();
        }

        @Override
        public void cancel() {
            this.myForkJoinTask.cancel(true);
        }

        @Override
        public void schedule() {
            throw new IncorrectOperationException();
        }

        @Override
        public void waitForCompletion(int millis) throws InterruptedException, ExecutionException, TimeoutException {
            HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
            while (!this.isDone()) {
                try {
                    this.myForkJoinTask.get(millis, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (CancellationException e2) {
                    if (this.isDone()) continue;
                    ForkJoinPool.commonPool().awaitQuiescence(millis, TimeUnit.MILLISECONDS);
                }
            }
        }

        private static enum Status {
            STARTED,
            EXECUTED;

        }
    }
}

