/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BindingCacheKey;
import com.intellij.configurationStore.KotlinAwareBeanBinding;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.THashMap;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a'\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\u00a2\u0006\u0002\u0010\b\u001a\u001e\u0010\u0002\u001a\u0002H\u0003\"\n\b\u0000\u0010\u0003\u0018\u0001*\u00020\t*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a#\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u0003*\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0012\u001a\u00020\t\u001a'\u0010\u0013\u001a\u00020\n\"\b\b\u0000\u0010\u0003*\u00020\t*\u0002H\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a!\u0010\u0017\u001a\u00020\u000e\"\b\b\u0000\u0010\u0003*\u00020\t*\u0002H\u00032\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"serializer", "Lcom/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase;", "deserialize", "T", "url", "Ljava/net/URL;", "aClass", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)Ljava/lang/Object;", "(Lorg/jdom/Element;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeAndLoadState", "", "Lcom/intellij/openapi/components/PersistentStateComponent;", "element", "deserializeInto", "bean", "serialize", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;)Lorg/jdom/Element;", "serializeInto", "(Ljava/lang/Object;Lorg/jdom/Element;)V", "projectModel-impl"})
@JvmName(name="XmlSerializer")
public final class XmlSerializer {
    private static final XmlSerializerImpl.XmlSerializerBase serializer = new XmlSerializerImpl.XmlSerializerBase(){
        private SoftReference<Map<BindingCacheKey, Binding>> _bindingCache;
        private final ReentrantReadWriteLock cacheLock;

        private final Map<BindingCacheKey, Binding> getBindingCache() {
            Map<K, V> map2;
            SoftReference<Map<BindingCacheKey, Binding>> softReference = this._bindingCache;
            Map<K, V> map3 = map2 = softReference != null ? (Map<K, V>)softReference.get() : null;
            if (map2 == null) {
                map2 = (Map)new THashMap();
                this._bindingCache = new SoftReference((Object)map2);
            }
            return map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            Binding binding;
            Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
            Intrinsics.checkParameterIsNotNull((Object)originalType, (String)"originalType");
            BindingCacheKey key = new BindingCacheKey(originalType, accessor);
            Map<BindingCacheKey, Binding> map2 = this.getBindingCache();
            ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                binding = map2.get(key);
            }
            finally {
                readLock.unlock();
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                Binding binding3;
                int n2;
                reentrantReadWriteLock = this.cacheLock;
                readLock = reentrantReadWriteLock.readLock();
                int n3 = 0;
                int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                int n5 = n4 - 1;
                if (n3 <= n5) {
                    do {
                        n2 = ++n3;
                        readLock.unlock();
                    } while (n3 != n5);
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    Binding binding4;
                    Binding binding5 = map2.get(key);
                    if (binding5 != null) {
                        Binding binding6;
                        Binding it;
                        Binding binding7 = it = (binding6 = binding5);
                        return binding7;
                    }
                    Binding binding8 = serializer.1.access$createClassBinding$s572079962(aClass, accessor, originalType);
                    if (binding8 == null) {
                        binding8 = (Binding)new KotlinAwareBeanBinding(aClass, accessor);
                    }
                    Binding binding9 = binding4 = binding8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)binding9, (String)"binding");
                    map2.put(key, binding9);
                    try {
                        binding4.init(originalType, (Serializer)this);
                    }
                    catch (XmlSerializationException e2) {
                        map2.remove(key);
                        throw (Throwable)e2;
                    }
                    Binding binding10 = binding4;
                    binding3 = binding10;
                }
                finally {
                    n2 = 0;
                    int n6 = n4 - 1;
                    if (n2 <= n6) {
                        do {
                            int it = ++n2;
                            readLock.lock();
                        } while (n2 != n6);
                    }
                    writeLock.unlock();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)binding3, (String)"cacheLock.write {\n      \u2026    }\n      binding\n    }");
                binding2 = binding3;
            }
            return binding2;
        }
        {
            this.cacheLock = new ReentrantReadWriteLock();
        }

        @Nullable
        public static final /* synthetic */ Binding access$createClassBinding$s572079962(@NotNull Class aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
            return XmlSerializerImpl.XmlSerializerBase.createClassBinding((Class)aClass, (MutableAccessor)accessor, (Type)originalType);
        }
    };

    @JvmOverloads
    @NotNull
    public static final <T> Element serialize(@NotNull T $receiver, @Nullable SerializationFilter filter2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        try {
            Element element;
            Class<?> clazz = $receiver.getClass();
            Binding binding = serializer.getClassBinding(clazz);
            if (binding instanceof BeanBinding) {
                Element element2 = ((BeanBinding)binding).serialize($receiver, true, filter2);
                element = element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"binding.serialize(this, true, filter)");
            } else {
                Object object = binding.serialize($receiver, null, filter2);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
                }
                element = (Element)object;
            }
            return element;
        }
        catch (XmlSerializationException e2) {
            throw (Throwable)e2;
        }
        catch (Exception e3) {
            throw (Throwable)new XmlSerializationException("Can't serialize instance of " + $receiver.getClass(), (Throwable)e3);
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Element serialize$default(Object object, SerializationFilter serializationFilter, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            serializationFilter = (SerializationFilter)new SkipDefaultsSerializationFilter();
        }
        return XmlSerializer.serialize(object, serializationFilter);
    }

    @JvmOverloads
    @NotNull
    public static final <T> Element serialize(@NotNull T $receiver) {
        return XmlSerializer.serialize$default($receiver, null, 1, null);
    }

    private static final <T> T deserialize(@NotNull Element $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)XmlSerializer.deserialize($receiver, Object.class);
    }

    public static final <T> T deserialize(@NotNull Element $receiver, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Binding binding = serializer.getClassBinding(aClass);
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.NotNullDeserializeBinding");
            }
            return (T)((NotNullDeserializeBinding)binding).deserialize(null, $receiver);
        }
        catch (XmlSerializationException e2) {
            throw (Throwable)e2;
        }
        catch (Exception e3) {
            throw (Throwable)new XmlSerializationException("Cannot deserialize class " + aClass.getName(), (Throwable)e3);
        }
    }

    public static final <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Document document = JDOMUtil.loadDocument((URL)url);
            document = JDOMXIncluder.resolve((Document)document, (String)url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e2) {
            throw (Throwable)new XmlSerializationException((Throwable)e2);
        }
        catch (JDOMException e3) {
            throw (Throwable)new XmlSerializationException((Throwable)e3);
        }
    }

    public static final void deserializeInto(@NotNull Element $receiver, @NotNull Object bean) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        try {
            Binding binding = serializer.getClassBinding(bean.getClass());
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding).deserializeInto(bean, $receiver);
        }
        catch (XmlSerializationException e2) {
            throw (Throwable)e2;
        }
        catch (Exception e3) {
            throw (Throwable)new XmlSerializationException((Throwable)e3);
        }
    }

    public static final void deserializeAndLoadState(@NotNull PersistentStateComponent<?> $receiver, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Class clazz = ComponentSerializationUtil.getStateClass($receiver.getClass());
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"ComponentSerializationUt\u2026tateClass<Any>(javaClass)");
        Object state = XmlSerializer.deserialize(element, clazz);
        Object s2 = state;
        if (!(s2 instanceof BaseState)) {
            s2 = null;
        }
        BaseState baseState = (BaseState)s2;
        if (baseState != null) {
            baseState.resetModificationCount();
        }
        PersistentStateComponent<?> persistentStateComponent = $receiver;
        if (persistentStateComponent == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        persistentStateComponent.loadState(state);
    }

    public static final <T> void serializeInto(@NotNull T $receiver, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        try {
            Binding binding;
            Binding binding2 = binding = serializer.getClassBinding($receiver.getClass());
            if (binding2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding2).serializeInto($receiver, element, null);
        }
        catch (XmlSerializationException e2) {
            throw (Throwable)e2;
        }
        catch (Exception e3) {
            throw (Throwable)new XmlSerializationException((Throwable)e3);
        }
    }
}

