/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

class SettingsXmlFile {
    private final File myFile;
    private final Document myDocument;
    private final Element myRootElement;

    SettingsXmlFile(@NotNull File file2) throws CannotConvertException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/conversion/impl/SettingsXmlFile", "<init>"));
        }
        this.myFile = file2;
        this.myDocument = JDomConvertingUtil.loadDocument(file2);
        this.myRootElement = this.myDocument.getRootElement();
    }

    public File getFile() {
        return this.myFile;
    }

    public Element getRootElement() {
        return this.myRootElement;
    }

    public void save() throws IOException {
        JDOMUtil.writeDocument((Document)this.myDocument, (File)this.myFile, (String)SystemProperties.getLineSeparator());
    }

    @Nullable
    public Element findComponent(String componentName) {
        return JDomSerializationUtil.findComponent(this.myRootElement, componentName);
    }
}

