/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EnterPasswordComponent;
import com.intellij.credentialStore.MasterPasswordDialog;
import com.intellij.credentialStore.PasswordDatabase;
import com.intellij.credentialStore.windows.WindowsCryptUtils;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a(\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00012\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00032\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\n\u001a\u00020\u00012\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00012\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\n\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"TEST_PASSWORD_VALUE", "", "checkPassAndConvertOldDb", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "password", "db", "Lcom/intellij/credentialStore/PasswordDatabase;", "convertOldDb", "oldKey", "isMasterPasswordValid", "", "rawTestKey", "", "kotlin.jvm.PlatformType", "credential-store"})
public final class DbV1ConvertorKt {
    private static final String TEST_PASSWORD_VALUE = "test password";

    public static final boolean isMasterPasswordValid(@NotNull String password, @NotNull PasswordDatabase db2) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)db2, (String)"db");
        byte[] key = EncryptionUtil.genPasswordKey(password);
        byte[] value2 = db2.myDatabase.get(new ByteArrayWrapper(EncryptionUtil.encryptKey(key, DbV1ConvertorKt.rawTestKey(password))));
        if (value2 != null) {
            return StringUtil.equals((CharSequence)((CharSequence)EncryptionUtil.decryptText(key, value2)), (CharSequence)TEST_PASSWORD_VALUE);
        }
        return false;
    }

    @Nullable
    public static final Map<CredentialAttributes, Credentials> checkPassAndConvertOldDb(@NotNull String password, @NotNull PasswordDatabase db2) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)db2, (String)"db");
        return DbV1ConvertorKt.isMasterPasswordValid(password, db2) ? DbV1ConvertorKt.convertOldDb(password, db2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Map<CredentialAttributes, Credentials> convertOldDb(@NotNull PasswordDatabase db2) {
        void result2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)db2, (String)"db");
        if (db2.myDatabase.size() <= 1) {
            return null;
        }
        Map<CredentialAttributes, Credentials> map2 = DbV1ConvertorKt.checkPassAndConvertOldDb("", db2);
        if (map2 != null) {
            Map<CredentialAttributes, Credentials> map3;
            Map<CredentialAttributes, Credentials> it = map3 = map2;
            return it;
        }
        if (SystemInfo.isWindows) {
            Object object2 = db2.myMasterPassword;
            if (db2.myMasterPassword != null) {
                Object object3;
                Object it = object = object2;
                try {
                    object3 = WindowsCryptUtils.unprotect(it);
                    Charset charset = Charsets.UTF_8;
                    object3 = new String((byte[])object3, charset);
                }
                catch (Exception e2) {
                    CredentialStoreKt.getLOG().warn((Throwable)e2);
                    object3 = null;
                }
                String string2 = (String)object3;
                object2 = string2;
                if (string2 != null) {
                    object = object2;
                    it = (String)object;
                    Map<CredentialAttributes, Credentials> map4 = DbV1ConvertorKt.checkPassAndConvertOldDb((String)it, db2);
                    if (map4 != null) {
                        object3 = map4;
                        Map it2 = (Map)object3;
                        return it2;
                    }
                }
            }
        }
        if (db2.myDatabase.size() <= 1) {
            return null;
        }
        object = new Ref.ObjectRef();
        object.element = null;
        MasterPasswordDialog dialog2 = new MasterPasswordDialog(new EnterPasswordComponent(new Function<String, Boolean>((Ref.ObjectRef)result2, db2){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ PasswordDatabase $db;

            public final boolean apply(String it) {
                String string2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                this.$result.element = DbV1ConvertorKt.checkPassAndConvertOldDb(string2, this.$db);
                return (Map)this.$result.element != null;
            }
            {
                this.$result = objectRef;
                this.$db = passwordDatabase;
            }
        }));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dialog2.doOKAction();
            dialog2.close(0);
        } else if (!dialog2.showAndGet()) {
            CredentialStoreKt.getLOG().warn("User cancelled master password dialog, will be recreated");
        }
        return (Map)result2.element;
    }

    @NotNull
    public static final Map<CredentialAttributes, Credentials> convertOldDb(@NotNull String oldKey, @NotNull PasswordDatabase db2) {
        Intrinsics.checkParameterIsNotNull((Object)oldKey, (String)"oldKey");
        Intrinsics.checkParameterIsNotNull((Object)db2, (String)"db");
        byte[] oldKeyB = EncryptionUtil.genPasswordKey(oldKey);
        ByteArrayWrapper testKey = new ByteArrayWrapper(EncryptionUtil.encryptKey(oldKeyB, DbV1ConvertorKt.rawTestKey(oldKey)));
        THashMap newDb = new THashMap(db2.myDatabase.size());
        Map<ByteArrayWrapper, byte[]> map2 = db2.myDatabase;
        Iterator<Map.Entry<ByteArrayWrapper, byte[]>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ByteArrayWrapper, byte[]> entry;
            Map.Entry<ByteArrayWrapper, byte[]> entry2 = entry = iterator2.next();
            ByteArrayWrapper key = entry2.getKey();
            entry2 = entry;
            byte[] value2 = entry2.getValue();
            if (Intrinsics.areEqual((Object)testKey, (Object)key)) continue;
            byte[] byArray = EncryptionUtil.decryptKey(oldKeyB, key.unwrap());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"EncryptionUtil.decryptKey(oldKeyB, key.unwrap())");
            CredentialAttributes attributes = CredentialStoreKt.toOldKeyAsIdentity(byArray);
            newDb.put((Object)attributes, (Object)new Credentials(attributes.getUserName(), EncryptionUtil.decryptText(oldKeyB, value2)));
        }
        return (Map)newDb;
    }

    private static final byte[] rawTestKey(String oldKey) {
        byte[][] byArrayArray;
        String string2 = "com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe/TEST_PASSWORD:" + oldKey;
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        int n2 = 0;
        byte[][] byArrayArray2 = byArrayArray = new byte[1][];
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byArrayArray[n2] = byArray2;
        return EncryptionUtil.hash(byArrayArray2);
    }

    static {
        TEST_PASSWORD_VALUE = TEST_PASSWORD_VALUE;
    }
}

