/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;

class EnterPasswordComponent {
    private JPanel myRootPanel;
    private JLabel myIconLabel;
    protected JEditorPane myPromptLabel;
    protected JPanel myPasswordPanel;
    protected JPasswordField myPasswordField;
    protected JLabel myPasswordLabel;
    @NotNull
    private final Function<String, Boolean> myPasswordConsumer;

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPasswordField;
    }

    public EnterPasswordComponent(@NotNull Function<String, Boolean> passwordConsumer) {
        if (passwordConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordConsumer", "com/intellij/credentialStore/EnterPasswordComponent", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myIconLabel.setText("");
        this.myIconLabel.setIcon(AllIcons.General.PasswordLock);
        this.myIconLabel.setDisabledIcon(AllIcons.General.PasswordLock);
        this.myPasswordConsumer = passwordConsumer;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myPasswordField.setText("pass");
        }
    }

    public ValidationInfo apply() {
        String password = new String(this.myPasswordField.getPassword());
        if (!this.myPasswordConsumer.apply(password).booleanValue()) {
            return new ValidationInfo("Password is incorrect", (JComponent)this.myPasswordField);
        }
        return null;
    }

    public String getHelpId() {
        return "settings_passwords_master_password_enter";
    }

    private void createUIComponents() {
        String note;
        if (MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported()) {
            note = "The passwords will be stored in the system MacOS keychain.";
        } else if (SystemInfo.isLinux) {
            note = "The passwords will be stored in the system keychain using Secret Service API.";
        } else if (SystemInfo.isWindows) {
            note = "The passwords will be stored in the KeePass database protected by your Windows account.";
        } else {
            String subNote = SystemInfo.isMacIntel64 ? "at least OS X 10.5 is required<br>to store in the system MacOS keychain" : "your OS is not supported, please <a href=\"https://youtrack.jetbrains.com/newIssue?project=IDEA&clearDraft=true&c=Assignee+develar&c=Subsystem+Password+Safe\">file issue</a>";
            note = "The passwords will be stored in IDE configuration files with weak protection<br>(" + subNote + ").";
        }
        this.myPromptLabel = ComponentsKt.htmlComponent("Master password is required to convert saved passwords.<br>" + note, UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JLabel jLabel;
        JPanel jPanel;
        JLabel jLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 10, 0, 20), null, 0, 0, null, null));
        this.myIconLabel = jLabel2 = new JLabel();
        jLabel2.setText("icon");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 3, 1, 9, 0, 0, 0, null, null, null));
        JEditorPane jEditorPane = this.myPromptLabel;
        jPanel2.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 2, 9, 0, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 2, 0, 3, 0, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0), null, 0, 0, null, null));
        this.myPasswordPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myPasswordLabel = jLabel = new JLabel();
        jLabel.setText("Password");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

