/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEncryption;
import com.intellij.credentialStore.kdbx.KdbxStreamFormat;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001aH\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000426\u0010\u0017\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00150\u0018H\u0002\u001a \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"SALSA20_IV", "", "kotlin.jvm.PlatformType", "createEmptyDatabase", "Lorg/jdom/Element;", "load", "inputStream", "Ljava/io/InputStream;", "encryption", "Lcom/intellij/credentialStore/kdbx/KdbxEncryption;", "loadKdbx", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "file", "Ljava/nio/file/Path;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "parseTime", "", "value", "", "processEntries", "", "groupElement", "processor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "container", "valueElement", "save", "rootElement", "outputStream", "Ljava/io/OutputStream;", "credential-store"})
public final class KdbxKt {
    private static final byte[] SALSA20_IV = DatatypeConverter.parseHexBinary((String)"E830094B97205D2A");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final KeePassDatabase loadKdbx(@NotNull Path file2, @NotNull KeePassCredentials credentials) {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        InputStream inputStream = PathKt.inputStreamIfExists((Path)file2);
        if (inputStream != null) {
            KeePassDatabase keePassDatabase2;
            Closeable closeable = inputStream;
            boolean bl = false;
            try {
                InputStream it = (InputStream)closeable;
                keePassDatabase2 = new KeePassDatabase(new KdbxStreamFormat().load(credentials, it));
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
            keePassDatabase = keePassDatabase2;
        } else {
            keePassDatabase = null;
        }
        return keePassDatabase;
    }

    public static final void save(@NotNull Element rootElement, @NotNull OutputStream outputStream, @NotNull KdbxEncryption encryption) {
        Charset charset;
        Element meta;
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Element element = rootElement.getChild("Meta");
        Object object = meta = element != null ? element.getChild("MemoryProtection") : null;
        if (meta != null) {
            SmartList propertiesToProtect = new SmartList();
            for (Element element2 : meta.getChildren()) {
                String propertyName = StringsKt.removePrefix((String)element2.getName(), (CharSequence)"Protect");
                if (!(Intrinsics.areEqual((Object)propertyName, (Object)element2.getName()) ^ true) || !StringsKt.equals((String)element2.getText(), (String)"true", (boolean)true)) continue;
                propertiesToProtect.add((Object)propertyName);
            }
            Element element3 = rootElement.getChild("Root");
            if (element3 != null && (element3 = element3.getChild("Group")) != null) {
                charset = element3;
                Element rootGroupElement = (Element)charset;
                KdbxKt.processEntries(rootGroupElement, (Function2<? super Element, ? super Element, Unit>)((Function2)new Function2<Element, Element, Unit>(propertiesToProtect, encryption){
                    final /* synthetic */ SmartList $propertiesToProtect$inlined;
                    final /* synthetic */ KdbxEncryption $encryption$inlined;
                    {
                        this.$propertiesToProtect$inlined = smartList;
                        this.$encryption$inlined = kdbxEncryption;
                        super(2);
                    }

                    public final void invoke(Element container, Element valueElement) {
                        String string2 = container.getChildText("Key");
                        if (string2 == null) {
                            return;
                        }
                        String key = string2;
                        for (String propertyName : this.$propertiesToProtect$inlined) {
                            byte[] byArray;
                            if (!Intrinsics.areEqual((Object)key, (Object)propertyName)) continue;
                            valueElement.setAttribute("Protected", "True");
                            String string3 = valueElement.getText();
                            Charset charset = null;
                            boolean bl = true;
                            Object var9_9 = null;
                            KdbxEncryption kdbxEncryption = this.$encryption$inlined;
                            Base64.Encoder encoder = Base64.getEncoder();
                            Element element = valueElement;
                            if (bl & true) {
                                charset = Charsets.UTF_8;
                            }
                            String string4 = string3;
                            if (string4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                            element.setText(encoder.encodeToString(kdbxEncryption.encrypt(byArray)));
                        }
                    }
                }));
            }
        }
        OutputStream outputStream2 = outputStream;
        charset = null;
        boolean bl = true;
        Object var7_8 = null;
        Element element4 = rootElement;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream2, charset);
        JDOMUtil.writeElement((Element)element4, (Writer)outputStreamWriter, (String)"\n");
    }

    private static final Element load(InputStream inputStream, KdbxEncryption encryption) {
        Element rootElement;
        block0: {
            Element element;
            rootElement = JdomKt.loadElement((InputStream)inputStream);
            Element element2 = rootElement.getChild("Root");
            if (element2 == null || (element2 = element2.getChild("Group")) == null) break block0;
            Element rootGroupElement = element = element2;
            KdbxKt.processEntries(rootGroupElement, (Function2<? super Element, ? super Element, Unit>)((Function2)new Function2<Element, Element, Unit>(encryption){
                final /* synthetic */ KdbxEncryption $encryption$inlined;
                {
                    this.$encryption$inlined = kdbxEncryption;
                    super(2);
                }

                public final void invoke(Element container, Element valueElement) {
                    if (StringsKt.equals((String)valueElement.getAttributeValue("Protected", "false"), (String)"true", (boolean)true)) {
                        byte[] byArray = Base64.getDecoder().decode(valueElement.getText());
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(valueElement.text)");
                        byte[] byArray2 = this.$encryption$inlined.decrypt(byArray);
                        Charset charset = Charsets.UTF_8;
                        Element element = valueElement;
                        String string2 = new String(byArray2, charset);
                        element.setText(string2);
                        valueElement.removeAttribute("Protected");
                    }
                }
            }));
        }
        return rootElement;
    }

    private static final void processEntries(Element groupElement, Function2<? super Element, ? super Element, Unit> processor2) {
        for (Element element : groupElement.getChildren()) {
            if (Intrinsics.areEqual((Object)element.getName(), (Object)"Group")) {
                Element element2 = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                KdbxKt.processEntries(element2, processor2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)element.getName(), (Object)"Entry")) continue;
            for (Element container : element.getChildren("String")) {
                Element valueElement;
                if (container.getChild("Value") == null) {
                    continue;
                }
                Element element3 = container;
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"container");
                processor2.invoke((Object)element3, (Object)valueElement);
            }
        }
    }

    @NotNull
    public static final Element createEmptyDatabase() {
        String creationDate = KeePassDatabaseKt.formattedNow();
        return JdomKt.loadElement((CharSequence)("<KeePassFile>" + "\n" + "    <Meta>" + "\n" + "      <Generator>IJ</Generator>" + "\n" + "      <HeaderHash></HeaderHash>" + "\n" + "      <DatabaseName>New Database</DatabaseName>" + "\n" + "      <DatabaseNameChanged>" + creationDate + "</DatabaseNameChanged>" + "\n" + "      <DatabaseDescription>Empty Database</DatabaseDescription>" + "\n" + "      <DatabaseDescriptionChanged>" + creationDate + "</DatabaseDescriptionChanged>" + "\n" + "      <DefaultUserName/>" + "\n" + "      <DefaultUserNameChanged>" + creationDate + "</DefaultUserNameChanged>" + "\n" + "      <MaintenanceHistoryDays>365</MaintenanceHistoryDays>" + "\n" + "      <Color/>" + "\n" + "      <MasterKeyChanged>" + creationDate + "</MasterKeyChanged>" + "\n" + "      <MasterKeyChangeRec>-1</MasterKeyChangeRec>" + "\n" + "      <MasterKeyChangeForce>-1</MasterKeyChangeForce>" + "\n" + "      <MemoryProtection>" + "\n" + "          <ProtectTitle>False</ProtectTitle>" + "\n" + "          <ProtectUserName>False</ProtectUserName>" + "\n" + "          <ProtectPassword>True</ProtectPassword>" + "\n" + "          <ProtectURL>False</ProtectURL>" + "\n" + "          <ProtectNotes>False</ProtectNotes>" + "\n" + "      </MemoryProtection>" + "\n" + "      <CustomIcons/>" + "\n" + "      <RecycleBinEnabled>True</RecycleBinEnabled>" + "\n" + "      <RecycleBinUUID>AAAAAAAAAAAAAAAAAAAAAA==</RecycleBinUUID>" + "\n" + "      <RecycleBinChanged>" + creationDate + "</RecycleBinChanged>" + "\n" + "      <EntryTemplatesGroup>AAAAAAAAAAAAAAAAAAAAAA==</EntryTemplatesGroup>" + "\n" + "      <EntryTemplatesGroupChanged>" + creationDate + "</EntryTemplatesGroupChanged>" + "\n" + "      <LastSelectedGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastSelectedGroup>" + "\n" + "      <LastTopVisibleGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleGroup>" + "\n" + "      <HistoryMaxItems>10</HistoryMaxItems>" + "\n" + "      <HistoryMaxSize>6291456</HistoryMaxSize>" + "\n" + "      <Binaries/>" + "\n" + "      <CustomData/>" + "\n" + "    </Meta>" + "\n" + "  </KeePassFile>"));
    }

    public static final long parseTime(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        try {
            return ZonedDateTime.parse(value2).toEpochSecond();
        }
        catch (DateTimeParseException e2) {
            return 0L;
        }
    }

    @NotNull
    public static final /* synthetic */ Element access$load(@NotNull InputStream inputStream, @NotNull KdbxEncryption encryption) {
        return KdbxKt.load(inputStream, encryption);
    }

    public static final /* synthetic */ byte[] access$getSALSA20_IV$p() {
        return SALSA20_IV;
    }
}

