/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataOutputStream;
import com.intellij.credentialStore.kdbx.HashedBlockInputStream;
import com.intellij.credentialStore.kdbx.HashedBlockOutputStream;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KdbxSerializerKt;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxSerializer;", "", "()V", "createEncryptedOutputStream", "Ljava/io/OutputStream;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "kdbxHeader", "Lcom/intellij/credentialStore/kdbx/KdbxHeader;", "outputStream", "createUnencryptedInputStream", "Ljava/io/InputStream;", "inputStream", "credential-store"})
public final class KdbxSerializer {
    public static final KdbxSerializer INSTANCE;

    @NotNull
    public final InputStream createUnencryptedInputStream(@NotNull KeePassCredentials credentials, @NotNull KdbxHeader kdbxHeader, @NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)kdbxHeader, (String)"kdbxHeader");
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        KdbxSerializerKt.readKdbxHeader(kdbxHeader, inputStream);
        InputStream decryptedInputStream = kdbxHeader.createDecryptedStream(credentials.getKey(), inputStream);
        KdbxSerializerKt.access$checkStartBytes(kdbxHeader, decryptedInputStream);
        HashedBlockInputStream blockInputStream = new HashedBlockInputStream(decryptedInputStream);
        if (Intrinsics.areEqual((Object)((Object)kdbxHeader.getCompressionFlags()), (Object)((Object)KdbxHeader.CompressionFlags.NONE))) {
            return blockInputStream;
        }
        return new GZIPInputStream(blockInputStream);
    }

    @NotNull
    public final OutputStream createEncryptedOutputStream(@NotNull KeePassCredentials credentials, @NotNull KdbxHeader kdbxHeader, @NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)kdbxHeader, (String)"kdbxHeader");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        KdbxSerializerKt.writeKdbxHeader(kdbxHeader, outputStream);
        OutputStream encryptedOutputStream = kdbxHeader.createEncryptedStream(credentials.getKey(), outputStream);
        new LittleEndianDataOutputStream(encryptedOutputStream).write(kdbxHeader.getStreamStartBytes());
        HashedBlockOutputStream blockOutputStream = new HashedBlockOutputStream(encryptedOutputStream);
        if (Intrinsics.areEqual((Object)((Object)kdbxHeader.getCompressionFlags()), (Object)((Object)KdbxHeader.CompressionFlags.NONE))) {
            return blockOutputStream;
        }
        return new GZIPOutputStream(blockOutputStream);
    }

    private KdbxSerializer() {
        INSTANCE = this;
    }

    static {
        new KdbxSerializer();
    }
}

