/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.win32.StdCallLibrary;

public interface W32API
extends StdCallLibrary {
    public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(Pointer.createConstant((long)(Pointer.SIZE == 8 ? -1L : 0xFFFFFFFFL)));
    public static final HWND HWND_BROADCAST = new HWND(Pointer.createConstant((int)65535));

    public static class WPARAM
    extends UINT_PTR {
        public WPARAM() {
            this(0L);
        }

        public WPARAM(long value2) {
            super(value2);
        }
    }

    public static class UINT_PTR
    extends IntegerType {
        public UINT_PTR() {
            super(Pointer.SIZE);
        }

        public UINT_PTR(long value2) {
            super(Pointer.SIZE, value2);
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.longValue());
        }
    }

    public static class LRESULT
    extends LONG_PTR {
        public LRESULT() {
            this(0L);
        }

        public LRESULT(long value2) {
            super(value2);
        }
    }

    public static class LPARAM
    extends LONG_PTR {
        public LPARAM() {
            this(0L);
        }

        public LPARAM(long value2) {
            super(value2);
        }
    }

    public static class SIZE_T
    extends ULONG_PTR {
        public SIZE_T() {
            this(0L);
        }

        public SIZE_T(long value2) {
            super(value2);
        }
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long value2) {
            super(Pointer.SIZE, value2);
        }
    }

    public static class SSIZE_T
    extends LONG_PTR {
        public SSIZE_T() {
            this(0L);
        }

        public SSIZE_T(long value2) {
            super(value2);
        }
    }

    public static class LONG_PTR
    extends IntegerType {
        public LONG_PTR() {
            this(0L);
        }

        public LONG_PTR(long value2) {
            super(Pointer.SIZE, value2);
        }
    }

    public static class HANDLEByReference
    extends ByReference {
        public HANDLEByReference() {
            this(null);
        }

        public HANDLEByReference(HANDLE h2) {
            super(Pointer.SIZE);
            this.setValue(h2);
        }

        public void setValue(HANDLE h2) {
            this.getPointer().setPointer(0L, h2 != null ? h2.getPointer() : null);
        }

        public HANDLE getValue() {
            Pointer p2 = this.getPointer().getPointer(0L);
            if (p2 == null) {
                return null;
            }
            if (INVALID_HANDLE_VALUE.getPointer().equals((Object)p2)) {
                return INVALID_HANDLE_VALUE;
            }
            HANDLE h2 = new HANDLE();
            h2.setPointer(p2);
            return h2;
        }
    }

    public static class HRESULT
    extends NativeLong {
        public HRESULT() {
        }

        public HRESULT(int value2) {
            super((long)value2);
        }
    }

    public static class HMODULE
    extends HINSTANCE {
    }

    public static class HINSTANCE
    extends HANDLE {
    }

    public static class HWND
    extends HANDLE {
        public HWND() {
        }

        public HWND(Pointer p2) {
            super(p2);
        }
    }

    public static class HRGN
    extends HANDLE {
    }

    public static class HBITMAP
    extends HANDLE {
    }

    public static class HICON
    extends HANDLE {
    }

    public static class HDC
    extends HANDLE {
    }

    public static class LONG
    extends IntegerType {
        public LONG() {
            this(0L);
        }

        public LONG(long value2) {
            super(Native.LONG_SIZE, value2);
        }
    }

    public static class DWORD
    extends IntegerType {
        public DWORD() {
            this(0L);
        }

        public DWORD(long value2) {
            super(4, value2);
        }
    }

    public static class WORD
    extends IntegerType {
        public WORD() {
            this(0L);
        }

        public WORD(long value2) {
            super(2, value2);
        }
    }

    public static class HANDLE
    extends PointerType {
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer p2) {
            this.setPointer(p2);
            this.immutable = true;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context2) {
            Object o2 = super.fromNative(nativeValue, context2);
            if (INVALID_HANDLE_VALUE.equals(o2)) {
                return INVALID_HANDLE_VALUE;
            }
            return o2;
        }

        public void setPointer(Pointer p2) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable reference");
            }
            super.setPointer(p2);
        }
    }
}

