/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends PropertiesContainer> {
    private final Property myParent;
    private final String myName;
    private boolean myImportant;
    private boolean myExpert;
    private boolean myDeprecated;

    public Property(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/designer/model/Property", "<init>"));
        }
        this.myParent = parent;
        this.myName = name;
    }

    @Nullable
    public Property<T> createForNewPresentation() {
        return this.createForNewPresentation(this.myParent, this.myName);
    }

    @Nullable
    public Property<T> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/designer/model/Property", "createForNewPresentation"));
        }
        return null;
    }

    @Nullable
    public String getGroup() {
        return null;
    }

    @Nullable
    public final Property getParent() {
        return this.myParent;
    }

    @NotNull
    public List<? extends Property<T>> getChildren(@Nullable T container) {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/Property", "getChildren"));
        }
        return list2;
    }

    @NotNull
    public String getPath() {
        String string2 = this.myParent == null ? this.myName : this.myParent.getPath() + "/" + this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/Property", "getPath"));
        }
        return string2;
    }

    @Nullable
    public Object getValue(@NotNull T container) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "getValue"));
        }
        return null;
    }

    public void setValue(@NotNull T container, @Nullable Object value2) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "setValue"));
        }
    }

    public boolean showAsDefault(@NotNull T container) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "showAsDefault"));
        }
        return this.isDefaultRecursively(container);
    }

    public final boolean isDefaultRecursively(@NotNull T container) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "isDefaultRecursively"));
        }
        if (!this.isDefaultValue(container)) {
            return false;
        }
        for (Property<T> child : this.getChildren(container)) {
            if (child.isDefaultRecursively(container)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultValue(@NotNull T container) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "isDefaultValue"));
        }
        return true;
    }

    public void setDefaultValue(@NotNull T container) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "setDefaultValue"));
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return true;
    }

    public boolean needRefreshPropertyList(@NotNull T container, @Nullable Object oldValue, @Nullable Object newValue) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "needRefreshPropertyList"));
        }
        return false;
    }

    public boolean needRefreshPropertyList() {
        return false;
    }

    public boolean closeEditorDuringRefresh() {
        return false;
    }

    @NotNull
    public Transferable doCopy(@NotNull T container, @NotNull Object commonValue) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/designer/model/Property", "doCopy"));
        }
        if (commonValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonValue", "com/intellij/designer/model/Property", "doCopy"));
        }
        TextTransferable textTransferable = new TextTransferable(commonValue.toString());
        if (textTransferable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/Property", "doCopy"));
        }
        return textTransferable;
    }

    @NotNull
    public final String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/Property", "getName"));
        }
        return string2;
    }

    @Nullable
    public String getTooltip() {
        return null;
    }

    public boolean isImportant() {
        return this.myImportant;
    }

    public void setImportant(boolean important) {
        this.myImportant = important;
    }

    public boolean isExpert() {
        return this.myExpert;
    }

    public void setExpert(boolean expert) {
        this.myExpert = expert;
    }

    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.myDeprecated = deprecated;
    }

    @NotNull
    public abstract PropertyRenderer getRenderer();

    @Nullable
    public abstract PropertyEditor getEditor();

    public boolean isEditable(@Nullable T component) {
        return this.getEditor() != null;
    }

    @Nullable
    public PsiElement getJavadocElement() {
        return null;
    }

    @Nullable
    public String getJavadocText() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof Property && this.getPath().equals(((Property)obj).getPath());
    }
}

