/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class AttachmentFactory {
    private static final String ERROR_MESSAGE_PATTERN = "[[[Can't get file contents: {0}]]]";

    public static Attachment createAttachment(Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return new Attachment(file2 != null ? file2.getPath() : "unknown.txt", document.getText());
    }

    public static Attachment createAttachment(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/AttachmentFactory", "createAttachment"));
        }
        return new Attachment(file2.getPresentableUrl(), AttachmentFactory.getBytes(file2), file2.getFileType().isBinary() ? "File is binary" : LoadTextUtil.loadText(file2).toString());
    }

    public static Attachment createAttachment(@NotNull File file2, boolean isBinary) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/AttachmentFactory", "createAttachment"));
        }
        byte[] bytes = AttachmentFactory.getBytes(file2);
        return new Attachment(file2.getPath(), bytes, isBinary ? "File is binary" : new String(bytes));
    }

    private static byte[] getBytes(File file2) {
        try {
            return FileUtil.loadFileBytes((File)file2);
        }
        catch (IOException e2) {
            return Attachment.getBytes((String)MessageFormat.format(ERROR_MESSAGE_PATTERN, e2.getMessage()));
        }
    }

    private static byte[] getBytes(VirtualFile file2) {
        try {
            return file2.contentsToByteArray();
        }
        catch (IOException e2) {
            return Attachment.getBytes((String)MessageFormat.format(ERROR_MESSAGE_PATTERN, e2.getMessage()));
        }
    }
}

