/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.errorreport.itn.ITNProxy;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.function.IntConsumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0017\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"previousExceptionThreadId", "", "setPluginInfo", "", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "errorBean", "Lcom/intellij/errorreport/bean/ErrorBean;", "showMessageDialog", "parentComponent", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "title", "icon", "Ljavax/swing/Icon;", "submit", "", "callback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "description", "updatePreviousThreadId", "threadId", "(Ljava/lang/Integer;)V", "platform-impl"})
public final class ITNReporterKt {
    private static int previousExceptionThreadId;

    public static final void setPluginInfo(@NotNull IdeaLoggingEvent event, @NotNull ErrorBean errorBean) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)errorBean, (String)"errorBean");
        Throwable t2 = event.getThrowable();
        if (t2 != null && (pluginId = IdeErrorsDialog.findPluginId(t2)) != null && (ideaPluginDescriptor = PluginManager.getPlugin(pluginId)) != null && (!ideaPluginDescriptor.isBundled() || ideaPluginDescriptor.allowBundledUpdate())) {
            errorBean.setPluginName(ideaPluginDescriptor.getName());
            errorBean.setPluginVersion(ideaPluginDescriptor.getVersion());
        }
    }

    private static final void updatePreviousThreadId(Integer threadId) {
        Integer n2 = threadId;
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        previousExceptionThreadId = n2;
    }

    private static final void showMessageDialog(Component parentComponent, Project project2, String message2, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            Messages.showMessageDialog((Component)parentComponent, (String)message2, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)project2, (String)message2, (String)title, (Icon)icon);
        }
    }

    private static final boolean submit(IdeaLoggingEvent event, Component parentComponent, Consumer<SubmittedReportInfo> callback, ErrorBean errorBean, String description) {
        Credentials credentials = ErrorReportConfigurable.Companion.getCredentials();
        if (CredentialAttributesKt.hasOnlyUserName((Credentials)credentials)) {
            if (!JetBrainsAccountDialogKt.showJetBrainsAccountDialog$default(parentComponent, null, 2, null).showAndGet()) {
                return false;
            }
            credentials = ErrorReportConfigurable.Companion.getCredentials();
        }
        errorBean.setDescription(description);
        errorBean.setMessage(event.getMessage());
        if (previousExceptionThreadId != 0) {
            errorBean.setPreviousException(previousExceptionThreadId);
        }
        ITNReporterKt.setPluginInfo(event, errorBean);
        Object data = event.getData();
        if (data instanceof AbstractMessage) {
            errorBean.setAssigneeId(((AbstractMessage)data).getAssigneeId());
            errorBean.setAttachments(((AbstractMessage)data).getIncludedAttachments());
        }
        Credentials credentials2 = credentials;
        String login = credentials2 != null ? credentials2.getUserName() : null;
        Credentials credentials3 = credentials;
        String password = credentials3 != null ? credentials3.getPasswordAsString() : null;
        CharSequence charSequence = login;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)password) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            login = "idea_anonymous";
            password = "guest";
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        ITNProxy.sendError(project2, login, password, errorBean, new IntConsumer(callback, project2){
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ Project $project;

            public final void accept(int threadId) {
                ITNReporterKt.access$updatePreviousThreadId(threadId);
                String linkText = String.valueOf(threadId);
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(ITNProxy.getBrowseUrl(threadId), linkText, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                this.$callback.consume((Object)reportInfo);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, reportInfo){
                    final /* synthetic */ submit.1 this$0;
                    final /* synthetic */ SubmittedReportInfo $reportInfo;

                    public final void run() {
                        StringBuilder text2 = new StringBuilder();
                        IdeErrorsDialog.appendSubmissionInformation(this.$reportInfo, text2);
                        text2.append('.').append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                        String content2 = XmlStringUtil.wrapInHtml((CharSequence)text2);
                        ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, content2, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$reportInfo = submittedReportInfo;
                    }
                });
            }
            {
                this.$callback = consumer2;
                this.$project = project2;
            }
        }, (Consumer<Exception>)((Consumer)new Consumer<Exception>(parentComponent, project2, callback, event, errorBean, description){
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Project $project;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ IdeaLoggingEvent $event;
            final /* synthetic */ ErrorBean $errorBean;
            final /* synthetic */ String $description;

            public final void consume(Exception e2) {
                Logger.getInstance(ITNReporter.class).info("reporting failed: " + e2);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, e2){
                    final /* synthetic */ submit.2 this$0;
                    final /* synthetic */ Exception $e;

                    public final void run() {
                        String msg;
                        Exception exception = this.$e;
                        String string2 = exception instanceof NoSuchEAPUserException ? DiagnosticBundle.message("error.report.authentication.failed", new Object[0]) : (msg = exception instanceof InternalEAPException ? DiagnosticBundle.message("error.report.posting.failed", this.$e.getMessage()) : DiagnosticBundle.message("error.report.sending.failure", new Object[0]));
                        if (this.$e instanceof UpdateAvailableException) {
                            String message2 = DiagnosticBundle.message("error.report.new.eap.build.message", this.$e.getMessage());
                            Component component = this.this$0.$parentComponent;
                            Project project2 = this.this$0.$project;
                            String string3 = message2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message");
                            String string4 = CommonBundle.getWarningTitle();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"CommonBundle.getWarningTitle()");
                            Icon icon = Messages.getWarningIcon();
                            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"Messages.getWarningIcon()");
                            ITNReporterKt.access$showMessageDialog(component, project2, string3, string4, icon);
                            this.this$0.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                            return;
                        }
                        if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ReportMessages.ERROR_REPORT, (String)msg).project(this.this$0.$project)).isYes()) {
                            this.this$0.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                        } else {
                            if (this.$e instanceof NoSuchEAPUserException) {
                                JetBrainsAccountDialogKt.showJetBrainsAccountDialog(this.this$0.$parentComponent, this.this$0.$project).show();
                            }
                            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                                final /* synthetic */ submit.1 this$0;

                                public final void run() {
                                    ITNReporterKt.access$submit(this.this$0.this$0.$event, this.this$0.this$0.$parentComponent, this.this$0.this$0.$callback, this.this$0.this$0.$errorBean, this.this$0.this$0.$description);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$e = exception;
                    }
                });
            }
            {
                this.$parentComponent = component;
                this.$project = project2;
                this.$callback = consumer2;
                this.$event = ideaLoggingEvent;
                this.$errorBean = errorBean;
                this.$description = string2;
            }
        }));
        return true;
    }

    public static final /* synthetic */ boolean access$submit(@NotNull IdeaLoggingEvent event, @NotNull Component parentComponent, @NotNull Consumer callback, @NotNull ErrorBean errorBean, @Nullable String description) {
        return ITNReporterKt.submit(event, parentComponent, (Consumer<SubmittedReportInfo>)callback, errorBean, description);
    }

    public static final /* synthetic */ void access$updatePreviousThreadId(@Nullable Integer threadId) {
        ITNReporterKt.updatePreviousThreadId(threadId);
    }

    public static final /* synthetic */ void access$showMessageDialog(@NotNull Component parentComponent, @Nullable Project project2, @NotNull String message2, @NotNull String title, @NotNull Icon icon) {
        ITNReporterKt.showMessageDialog(parentComponent, project2, message2, title, icon);
    }
}

