/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.LogMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogMessageEx
extends LogMessage {
    private final IdeaLoggingEvent myEvent;
    private final String myTitle;
    private final String myNotificationText;

    public LogMessageEx(IdeaLoggingEvent aEvent, String title, String notificationText) {
        super(aEvent);
        this.myEvent = aEvent;
        this.myTitle = title;
        this.myNotificationText = notificationText;
    }

    public String getNotificationText() {
        return this.myNotificationText;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public IdeaLoggingEvent toEvent() {
        return this.myEvent;
    }

    public static IdeaLoggingEvent createEvent(String userMessage, String details, Attachment ... attachments) {
        return LogMessageEx.createEvent(userMessage, details, userMessage, null, Arrays.asList(attachments));
    }

    public static IdeaLoggingEvent createEvent(final String userMessage, final String details, final @Nullable String title, final @Nullable String notificationText, final Collection<Attachment> attachments) {
        Throwable throwable = new Throwable(){

            @Override
            public void printStackTrace(PrintWriter s2) {
                s2.print(details);
            }

            @Override
            public void printStackTrace(PrintStream s2) {
                s2.print(details);
            }
        };
        return new IdeaLoggingEvent(userMessage, throwable){

            public Object getData() {
                LogMessageEx logMessageEx = new LogMessageEx(this, title != null ? title : userMessage, notificationText);
                for (Attachment attachment : attachments) {
                    logMessageEx.addAttachment(attachment);
                }
                return logMessageEx;
            }
        };
    }

    public static void error(@NotNull Logger logger, @NonNls @NotNull String message2, String ... attachmentText) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        if (attachmentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachmentText", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        LogMessageEx.error(logger, message2, new Throwable(), attachmentText);
    }

    public static void error(@NotNull Logger logger, @NotNull String message2, @NotNull Throwable cause, String ... attachmentText) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        if (attachmentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachmentText", "com/intellij/diagnostic/LogMessageEx", "error"));
        }
        StringBuilder detailsBuffer = new StringBuilder();
        for (String detail : attachmentText) {
            detailsBuffer.append(detail).append(",");
        }
        if (attachmentText.length > 0 && detailsBuffer.length() > 0) {
            detailsBuffer.setLength(detailsBuffer.length() - 1);
        }
        Attachment attachment = detailsBuffer.length() > 0 ? new Attachment("current-context.txt", detailsBuffer.toString()) : null;
        logger.error((Object)LogMessageEx.createEvent(message2, ExceptionUtil.getThrowableText((Throwable)cause), null, null, attachment));
    }

    public static IdeaLoggingEvent createEvent(String userMessage, String details, @Nullable String title, @Nullable String notificationText, @Nullable Attachment attachment) {
        return LogMessageEx.createEvent(userMessage, details, title, notificationText, attachment != null ? Collections.singletonList(attachment) : Collections.emptyList());
    }
}

