/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginConflictDialog
extends DialogWrapper {
    public static final int WIDTH = 450;
    @NotNull
    private final List<PluginId> myConflictingPlugins;
    private final boolean myIsConflictWithPlatform;
    @Nullable
    private final List<JBRadioButton> myRadioButtons;
    private JPanel myContentPane;
    private JBLabel myTopMessageLabel;
    private JPanel myConflictingPluginsListPanel;

    public PluginConflictDialog(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        if (conflictingPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingPlugins", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "<init>"));
        }
        super(false);
        this.myConflictingPlugins = conflictingPlugins;
        this.myIsConflictWithPlatform = isConflictWithPlatform;
        this.myRadioButtons = this.myIsConflictWithPlatform ? null : new ArrayList<JBRadioButton>();
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("error.dialog.conflict.plugin.title", new Object[0]));
        this.init();
        this.setCrossClosesWindow(false);
        this.getOKAction().updateText();
        this.myTopMessageLabel.setText(PluginConflictDialog.getTopMessageText(conflictingPlugins, isConflictWithPlatform));
        this.myTopMessageLabel.setPreferredSize(new Dimension(450, (int)this.myTopMessageLabel.getPreferredSize().getHeight()));
        this.myContentPane.setPreferredSize(new Dimension(450, (int)this.myContentPane.getMinimumSize().getHeight()));
    }

    private static String getTopMessageText(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        if (conflictingPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingPlugins", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getTopMessageText"));
        }
        int pluginsNumber = conflictingPlugins.size();
        if (isConflictWithPlatform) {
            return DiagnosticBundle.message("error.dialog.conflict.plugin.header.platform", pluginsNumber);
        }
        List names = conflictingPlugins.stream().map(PluginConflictDialog::getPluginNameOrId).map(s2 -> "<b>" + s2 + "</b>").collect(Collectors.toList());
        return DiagnosticBundle.message("error.dialog.conflict.plugin.header.each.other", StringUtil.join(names.subList(0, pluginsNumber - 1), (String)", "), names.get(pluginsNumber - 1));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.myConflictingPluginsListPanel = new JPanel(new GridLayout(0, 1));
        List pluginDescriptions = this.myConflictingPlugins.stream().map(plugin -> this.getChooserPanelForPlugin(buttonGroup2, (PluginId)plugin)).collect(Collectors.toList());
        if (!this.myIsConflictWithPlatform) {
            pluginDescriptions.add(this.getChooserPanelForPlugin(buttonGroup2, null));
        }
        for (JPanel panel2 : pluginDescriptions) {
            this.myConflictingPluginsListPanel.add(panel2);
        }
        this.setUpDefaultSelection();
    }

    @NotNull
    private JPanel getChooserPanelForPlugin(@NotNull ButtonGroup buttonGroup2, @Nullable PluginId plugin) {
        if (buttonGroup2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonGroup", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getChooserPanelForPlugin"));
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        if (!this.myIsConflictWithPlatform) {
            assert (this.myRadioButtons != null);
            final JBRadioButton radioButton = new JBRadioButton();
            this.myRadioButtons.add(radioButton);
            buttonGroup2.add((AbstractButton)radioButton);
            radioButton.addChangeListener(e2 -> this.getOKAction().updateText());
            panel2.add((Component)radioButton, "West");
            panel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    radioButton.setSelected(true);
                }
            });
        }
        JPanel descriptionPanel = plugin != null ? PluginConflictDialog.getPluginDescriptionPanel(plugin, !this.myIsConflictWithPlatform) : PluginConflictDialog.getDisableAllPanel();
        descriptionPanel.setBorder((Border)new JBEmptyBorder(10, this.myIsConflictWithPlatform ? 10 : 0, 10, 20));
        panel2.add((Component)descriptionPanel, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getChooserPanelForPlugin"));
        }
        return jPanel;
    }

    private void setUpDefaultSelection() {
        if (this.myIsConflictWithPlatform) {
            return;
        }
        assert (this.myRadioButtons != null && this.myRadioButtons.size() == this.myConflictingPlugins.size() + 1);
        for (int i2 = 0; i2 < this.myConflictingPlugins.size(); ++i2) {
            IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(this.myConflictingPlugins.get(i2));
            if (pluginDescriptor == null || !pluginDescriptor.isBundled() && !StringUtil.equalsIgnoreCase((CharSequence)pluginDescriptor.getVendor(), (CharSequence)"JetBrains")) continue;
            this.myRadioButtons.get(i2).setSelected(true);
            return;
        }
        this.myRadioButtons.get(this.myRadioButtons.size() - 1).setSelected(true);
    }

    @NotNull
    private static JPanel getPluginDescriptionPanel(@NotNull PluginId plugin, boolean addUseWord) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginDescriptionPanel"));
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(plugin);
        if (pluginDescriptor == null) {
            panel2.add((Component)new JBLabel(plugin.getIdString()), "Center");
            JPanel jPanel = panel2;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginDescriptionPanel"));
            }
            return jPanel;
        }
        StringBuilder sb2 = new StringBuilder("<html>");
        if (addUseWord) {
            sb2.append("Use ");
        }
        sb2.append(pluginDescriptor.getName());
        if (pluginDescriptor.getVendor() != null) {
            sb2.append(" by ").append(pluginDescriptor.getVendor());
        }
        sb2.append("</html>");
        panel2.add((Component)new JBLabel(sb2.toString()));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginDescriptionPanel"));
        }
        return jPanel;
    }

    @NotNull
    private static String getPluginNameOrId(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginNameOrId"));
        }
        IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
        if (pluginDescriptor == null) {
            String string2 = pluginId.getIdString();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginNameOrId"));
            }
            return string2;
        }
        String string3 = pluginDescriptor.getName();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getPluginNameOrId"));
        }
        return string3;
    }

    @NotNull
    private static JPanel getDisableAllPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("error.dialog.conflict.plugin.disable.all", new Object[0])));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getDisableAllPanel"));
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "createActions"));
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DisableAction();
    }

    @NotNull
    protected DisableAction getOKAction() {
        DisableAction disableAction = (DisableAction)((Object)this.myOKAction);
        if (disableAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog", "getOKAction"));
        }
        return disableAction;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(400, -1));
        this.myTopMessageLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myConflictingPluginsListPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class DisableAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAction() {
            super((DialogWrapper)PluginConflictDialog.this, "Disable");
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        public void updateText() {
            this.putValue("Name", this.getButtonText());
            PluginConflictDialog.this.repaint();
        }

        @NotNull
        private String getButtonText() {
            if (PluginConflictDialog.this.myIsConflictWithPlatform) {
                String string2 = DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog$DisableAction", "getButtonText"));
                }
                return string2;
            }
            assert (PluginConflictDialog.this.myRadioButtons != null);
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (!((JBRadioButton)PluginConflictDialog.this.myRadioButtons.get(i2)).isSelected()) continue;
                String string3 = DiagnosticBundle.message("error.dialog.conflict.plugin.button.enable.and.restart", new Object[0]);
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog$DisableAction", "getButtonText"));
                }
                return string3;
            }
            String string4 = DiagnosticBundle.message("error.dialog.conflict.plugin.button.disable.all", new Object[0]);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/PluginConflictDialog$DisableAction", "getButtonText"));
            }
            return string4;
        }

        protected void doAction(ActionEvent e2) {
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (PluginConflictDialog.this.myRadioButtons != null && ((JBRadioButton)PluginConflictDialog.this.myRadioButtons.get(i2)).isSelected()) continue;
                PluginManagerCore.disablePlugin(((PluginId)PluginConflictDialog.this.myConflictingPlugins.get(i2)).getIdString());
            }
            PluginConflictDialog.this.close(0);
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }
}

