/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleManagerBase
implements LogConsoleManager,
Disposable {
    private final Project myProject;
    private final Map<AdditionalTabComponent, Content> myAdditionalContent;
    private final GlobalSearchScope mySearchScope;

    protected LogConsoleManagerBase(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "<init>"));
        }
        this.myAdditionalContent = new THashMap();
        this.myProject = project2;
        this.mySearchScope = searchScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLogConsole(@NotNull String name, final @NotNull String path, @NotNull Charset charset, long skippedContent, @NotNull RunConfigurationBase runConfigurationBase) {
        void runConfiguration;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        if (runConfigurationBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        this.doAddLogConsole(new LogConsoleImpl(this.myProject, new File(path), charset, skippedContent, name, false, this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(path);
            }
        }, path, this.getDefaultIcon(), (RunProfile)runConfiguration);
    }

    private void doAddLogConsole(final @NotNull LogConsoleBase log, String id, Icon icon, @Nullable RunProfile runProfile) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "doAddLogConsole"));
        }
        if (runProfile instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runProfile).customizeLogConsole((LogConsole)log);
        }
        log.attachStopLogConsoleTrackingListener(this.getProcessHandler());
        this.addAdditionalTabComponent(log, id, icon);
        this.getUi().addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                log.activate();
            }
        }, (Disposable)log);
    }

    private boolean isConsoleActive(String id) {
        Content content2 = this.getUi().findContent(id);
        return content2 != null && content2.isSelected();
    }

    @Override
    public void removeLogConsole(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "removeLogConsole"));
        }
        Content content2 = this.getUi().findContent(path);
        if (content2 != null) {
            this.removeAdditionalTabComponent((LogConsoleBase)((Object)content2.getComponent()));
        }
    }

    public void addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id) {
        if (tabComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabComponent", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addAdditionalTabComponent"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addAdditionalTabComponent"));
        }
        this.addAdditionalTabComponent(tabComponent, id, this.getDefaultIcon());
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon) {
        if (tabComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabComponent", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addAdditionalTabComponent"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addAdditionalTabComponent"));
        }
        Content logContent = this.getUi().createContent(id, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), icon, tabComponent.getPreferredFocusableComponent());
        this.myAdditionalContent.put(tabComponent, logContent);
        this.getUi().addContent(logContent);
        return logContent;
    }

    public void removeAdditionalTabComponent(@NotNull AdditionalTabComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "removeAdditionalTabComponent"));
        }
        Disposer.dispose((Disposable)component);
        Content content2 = this.myAdditionalContent.remove(component);
        if (!this.getUi().isDisposed()) {
            this.getUi().removeContent(content2, true);
        }
    }

    public void dispose() {
        for (AdditionalTabComponent component : (AdditionalTabComponent[])ArrayUtil.toObjectArray(this.myAdditionalContent.keySet(), AdditionalTabComponent.class)) {
            this.removeAdditionalTabComponent(component);
        }
    }

    protected abstract Icon getDefaultIcon();

    protected abstract RunnerLayoutUi getUi();

    public abstract ProcessHandler getProcessHandler();
}

