/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseShowDiffAction
extends AnAction
implements DumbAware {
    BaseShowDiffAction() {
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/BaseShowDiffAction", "update"));
        }
        Presentation presentation = e2.getPresentation();
        boolean canShow = this.isAvailable(e2);
        presentation.setEnabled(canShow);
        if (ActionPlaces.isPopupPlace((String)e2.getPlace())) {
            presentation.setVisible(canShow);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/BaseShowDiffAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        DiffRequest request2 = this.getDiffRequest(e2);
        if (request2 == null) {
            return;
        }
        DiffManager.getInstance().showDiff(project2, request2);
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    protected static boolean hasContent(VirtualFile file2) {
        return !(file2 instanceof VirtualFileWithoutContent);
    }

    @Nullable
    protected abstract DiffRequest getDiffRequest(@NotNull AnActionEvent var1);
}

