/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFileWithEditorAction", "isAvailable"));
        }
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e2);
        if (selectedFile == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e2);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFileWithEditorAction", "getSelectedFile"));
        }
        VirtualFile[] array2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (array2 == null || array2.length != 1 || array2[0].isDirectory()) {
            return null;
        }
        return array2[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFileWithEditorAction", "getEditingFile"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return null;
        }
        return FileEditorManagerEx.getInstanceEx(project2).getCurrentFile();
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/diff/actions/CompareFileWithEditorAction", "canCompare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/diff/actions/CompareFileWithEditorAction", "canCompare"));
        }
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e2) {
        Editor[] editors;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFileWithEditorAction", "getDiffRequest"));
        }
        Project project2 = e2.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e2);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e2);
        assert (selectedFile != null && currentFile != null);
        ContentDiffRequest request2 = DiffRequestFactory.getInstance().createFromFiles(project2, selectedFile, currentFile);
        DiffContent editorContent = (DiffContent)request2.getContents().get(1);
        if (editorContent instanceof DocumentContent && (editors = EditorFactory.getInstance().getEditors(((DocumentContent)editorContent).getDocument())).length != 0) {
            request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)editors[0].getCaretModel().getLogicalPosition().line));
        }
        return request2;
    }
}

