/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "update"));
        }
        super.update(e2);
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        String text2 = "Compare Files";
        if (files2 != null && files2.length == 1) {
            text2 = "Compare With...";
        } else if (files2 != null && files2.length == 2) {
            Type type2;
            Type type1 = CompareFilesAction.getType(files2[0]);
            if (type1 != (type2 = CompareFilesAction.getType(files2[1]))) {
                text2 = "Compare";
            } else {
                switch (type1) {
                    case FILE: {
                        text2 = "Compare Files";
                        break;
                    }
                    case DIRECTORY: {
                        text2 = "Compare Directories";
                        break;
                    }
                    case ARCHIVE: {
                        text2 = "Compare Archives";
                    }
                }
            }
        }
        e2.getPresentation().setText(text2);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "isAvailable"));
        }
        DiffRequest request2 = (DiffRequest)e2.getData(DIFF_REQUEST);
        if (request2 != null) {
            return true;
        }
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null) {
            return false;
        }
        if (files2.length == 1) {
            return CompareFilesAction.hasContent(files2[0]);
        }
        if (files2.length == 2) {
            return CompareFilesAction.hasContent(files2[0]) && CompareFilesAction.hasContent(files2[1]);
        }
        return false;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/CompareFilesAction", "getDiffRequest"));
        }
        Project project2 = e2.getProject();
        DiffRequest diffRequest = (DiffRequest)e2.getData(DIFF_REQUEST);
        if (diffRequest != null) {
            return diffRequest;
        }
        VirtualFile[] data = (VirtualFile[])e2.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (data.length == 1) {
            VirtualFile otherFile = CompareFilesAction.getOtherFile(project2, data[0]);
            if (otherFile == null) {
                return null;
            }
            if (!CompareFilesAction.hasContent(data[0])) {
                return null;
            }
            return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], otherFile);
        }
        return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], data[1]);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        String key;
        FileChooserDescriptor descriptor2;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "getOtherFile"));
        }
        Type type = CompareFilesAction.getType(file2);
        if (type == Type.DIRECTORY || type == Type.ARCHIVE) {
            descriptor2 = new FileChooserDescriptor(false, true, true, true, true, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor2 = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project2, key, file2);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project2, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project2, @NotNull String key, @NotNull VirtualFile file2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        if (project2 == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
            }
            return virtualFile;
        }
        String path = PropertiesComponent.getInstance((Project)project2).getValue(key);
        if (path == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
            }
            return virtualFile;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile = lastSelection != null ? lastSelection : file2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getDefaultSelection"));
        }
        return virtualFile;
    }

    private static void updateDefaultSelection(@Nullable Project project2, @NotNull String key, @NotNull VirtualFile file2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/actions/CompareFilesAction", "updateDefaultSelection"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/actions/CompareFilesAction", "updateDefaultSelection"));
        }
        if (project2 == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project2).setValue(key, file2.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file2) {
        if (file2 == null) {
            Type type = Type.FILE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getType"));
            }
            return type;
        }
        if (file2.isDirectory()) {
            Type type = Type.DIRECTORY;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getType"));
            }
            return type;
        }
        if (file2.getFileType() instanceof ArchiveFileType) {
            Type type = Type.ARCHIVE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getType"));
            }
            return type;
        }
        Type type = Type.FILE;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/CompareFilesAction", "getType"));
        }
        return type;
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

