/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyUndoRedoAction
extends DumbAwareAction {
    @NotNull
    private final UndoManager myUndoManager;
    @NotNull
    private final TextEditor myEditor;
    private final boolean myUndo;

    private ProxyUndoRedoAction(@NotNull UndoManager manager, @NotNull TextEditor editor, boolean undo) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/diff/actions/ProxyUndoRedoAction", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/ProxyUndoRedoAction", "<init>"));
        }
        ActionUtil.copyFrom((AnAction)this, (String)(undo ? "$Undo" : "$Redo"));
        this.myUndoManager = manager;
        this.myEditor = editor;
        this.myUndo = undo;
    }

    public static void register(@Nullable Project project2, @NotNull Editor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/ProxyUndoRedoAction", "register"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/actions/ProxyUndoRedoAction", "register"));
        }
        UndoManager undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        if (undoManager != null) {
            DiffUtil.registerAction((AnAction)new ProxyUndoRedoAction(undoManager, textEditor, true), component);
            DiffUtil.registerAction((AnAction)new ProxyUndoRedoAction(undoManager, textEditor, false), component);
        }
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(this.myUndo ? this.myUndoManager.isUndoAvailable((FileEditor)this.myEditor) : this.myUndoManager.isRedoAvailable((FileEditor)this.myEditor));
    }

    public void actionPerformed(AnActionEvent e2) {
        if (this.myUndo) {
            this.myUndoManager.undo((FileEditor)this.myEditor);
        } else {
            this.myUndoManager.redo((FileEditor)this.myEditor);
        }
    }
}

