/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.actions.impl.GoToChangePopupAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class GoToChangePopupBuilder {
    private static final Key<JBPopup> POPUP_KEY = Key.create((String)"Diff.RequestChainGoToPopup");

    @NotNull
    public static AnAction create(@NotNull DiffRequestChain chain, @NotNull Consumer<Integer> onSelected) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/diff/actions/impl/GoToChangePopupBuilder", "create"));
        }
        if (onSelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/diff/actions/impl/GoToChangePopupBuilder", "create"));
        }
        if (chain instanceof Chain) {
            AnAction anAction = ((Chain)chain).createGoToChangeAction(onSelected);
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/GoToChangePopupBuilder", "create"));
            }
            return anAction;
        }
        SimpleGoToChangePopupAction simpleGoToChangePopupAction = new SimpleGoToChangePopupAction(chain, onSelected);
        if (simpleGoToChangePopupAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/GoToChangePopupBuilder", "create"));
        }
        return simpleGoToChangePopupAction;
    }

    private static class SimpleGoToChangePopupAction
    extends BaseGoToChangePopupAction<DiffRequestChain> {
        public SimpleGoToChangePopupAction(@NotNull DiffRequestChain chain, @NotNull Consumer<Integer> onSelected) {
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$SimpleGoToChangePopupAction", "<init>"));
            }
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$SimpleGoToChangePopupAction", "<init>"));
            }
            super(chain, onSelected);
        }

        @Override
        @NotNull
        protected JBPopup createPopup(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$SimpleGoToChangePopupAction", "createPopup"));
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MyListPopupStep());
            if (listPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$SimpleGoToChangePopupAction", "createPopup"));
            }
            return listPopup;
        }

        private class MyListPopupStep
        extends BaseListPopupStep<DiffRequestProducer> {
            public MyListPopupStep() {
                super("Go To Change", SimpleGoToChangePopupAction.this.myChain.getRequests());
                this.setDefaultOptionIndex(SimpleGoToChangePopupAction.this.myChain.getIndex());
            }

            @NotNull
            public String getTextFor(DiffRequestProducer value2) {
                String string2 = value2.getName();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$SimpleGoToChangePopupAction$MyListPopupStep", "getTextFor"));
                }
                return string2;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(DiffRequestProducer selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    int index = SimpleGoToChangePopupAction.this.myChain.getRequests().indexOf(selectedValue);
                    SimpleGoToChangePopupAction.this.myOnSelected.consume((Object)index);
                });
            }
        }
    }

    public static abstract class BaseGoToChangePopupAction<Chain extends DiffRequestChain>
    extends GoToChangePopupAction {
        @NotNull
        protected final Chain myChain;
        @NotNull
        protected final Consumer<Integer> myOnSelected;

        public BaseGoToChangePopupAction(@NotNull Chain chain, @NotNull Consumer<Integer> onSelected) {
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$BaseGoToChangePopupAction", "<init>"));
            }
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$BaseGoToChangePopupAction", "<init>"));
            }
            this.myChain = chain;
            this.myOnSelected = onSelected;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$BaseGoToChangePopupAction", "update"));
            }
            if (this.myChain.getRequests().size() <= 1) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e2.getPresentation().setEnabledAndVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/GoToChangePopupBuilder$BaseGoToChangePopupAction", "actionPerformed"));
            }
            JBPopup oldPopup = (JBPopup)this.myChain.getUserData(POPUP_KEY);
            if (oldPopup != null && oldPopup.isVisible()) {
                oldPopup.cancel();
            }
            final JBPopup popup2 = this.createPopup(e2);
            this.myChain.putUserData(POPUP_KEY, (Object)popup2);
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (myChain.getUserData(POPUP_KEY) == popup2) {
                        myChain.putUserData(POPUP_KEY, null);
                    }
                }
            });
            InputEvent event = e2.getInputEvent();
            if (event instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)event));
            } else {
                popup2.showInBestPositionFor(e2.getDataContext());
            }
        }

        @NotNull
        protected abstract JBPopup createPopup(@NotNull AnActionEvent var1);
    }

    public static interface Chain
    extends DiffRequestChain {
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> var1);
    }
}

