/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInEditorAction
extends EditSourceAction
implements DumbAware {
    public static final DataKey<OpenInEditorAction> KEY = DataKey.create((String)"DiffOpenInEditorAction");
    @Nullable
    private final Runnable myAfterRunnable;

    public OpenInEditorAction(@Nullable Runnable afterRunnable) {
        ActionUtil.copyFrom((AnAction)this, (String)"EditSource");
        this.myAfterRunnable = afterRunnable;
    }

    @Override
    public void update(@NotNull AnActionEvent e2) {
        DiffContext context2;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/OpenInEditorAction", "update"));
        }
        if (!ActionPlaces.isToolbarPlace((String)e2.getPlace())) {
            e2.getPresentation().setEnabledAndVisible(true);
            return;
        }
        DiffRequest request2 = (DiffRequest)e2.getData(DiffDataKeys.DIFF_REQUEST);
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.GO_TO_SOURCE_DISABLE, new UserDataHolder[]{request2, context2 = (DiffContext)e2.getData(DiffDataKeys.DIFF_CONTEXT)})) {
            e2.getPresentation().setVisible(false);
            e2.getPresentation().setEnabled(false);
        }
        if (e2.getProject() == null) {
            e2.getPresentation().setVisible(true);
            e2.getPresentation().setEnabled(false);
            return;
        }
        Object[] navigatables = (Navigatable[])e2.getData(DiffDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables == null || !ContainerUtil.exists((Object[])navigatables, it -> it.canNavigate())) {
            e2.getPresentation().setVisible(true);
            e2.getPresentation().setEnabled(false);
            return;
        }
        e2.getPresentation().setEnabledAndVisible(true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/OpenInEditorAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        Navigatable[] navigatables = (Navigatable[])e2.getData(DiffDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables == null) {
            return;
        }
        this.openEditor(project2, navigatables);
    }

    public void openEditor(@NotNull Project project2, @NotNull Navigatable navigatable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/actions/impl/OpenInEditorAction", "openEditor"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/diff/actions/impl/OpenInEditorAction", "openEditor"));
        }
        this.openEditor(project2, new Navigatable[]{navigatable});
    }

    public void openEditor(@NotNull Project project2, @NotNull Navigatable[] navigatables) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/actions/impl/OpenInEditorAction", "openEditor"));
        }
        if (navigatables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatables", "com/intellij/diff/actions/impl/OpenInEditorAction", "openEditor"));
        }
        boolean success = false;
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            navigatable.navigate(true);
            success = true;
        }
        if (success && this.myAfterRunnable != null) {
            this.myAfterRunnable.run();
        }
    }
}

