/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
extends ApplicationStarterEx {
    protected static final Logger LOG = Logger.getInstance(ApplicationStarterBase.class);

    protected abstract boolean checkArguments(@NotNull String[] var1);

    @NotNull
    protected abstract String getUsageMessage();

    protected abstract void processCommand(@NotNull String[] var1, @Nullable String var2) throws Exception;

    public boolean isHeadless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalCommandLine(@NotNull String[] args, @Nullable String currentDirectory) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/ApplicationStarterBase", "processExternalCommandLine"));
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args, currentDirectory);
        }
        catch (Exception e2) {
            Messages.showMessageDialog((String)String.format("Error showing %s: %s", this.getCommandName(), e2.getMessage()), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.out.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        try {
            this.processCommand(args, null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(0);
    }

    @NotNull
    public static List<VirtualFile> findFiles(@NotNull List<String> filePaths, @Nullable String currentDirectory) throws Exception {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/diff/applications/ApplicationStarterBase", "findFiles"));
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            VirtualFile virtualFile = ApplicationStarterBase.findFile(path, currentDirectory);
            if (virtualFile == null) {
                throw new Exception("Can't find file " + path);
            }
            files2.add(virtualFile);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(files2));
        for (int i2 = 0; i2 < filePaths.size(); ++i2) {
            if (((VirtualFile)files2.get(i2)).isValid()) continue;
            throw new Exception("Can't find file " + filePaths.get(i2));
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/ApplicationStarterBase", "findFiles"));
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path, @Nullable String currentDirectory) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/applications/ApplicationStarterBase", "findFile"));
        }
        File file2 = ApplicationStarterBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @NotNull
    public static File getFile(@NotNull String path, @Nullable String currentDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/applications/ApplicationStarterBase", "getFile"));
        }
        File file2 = new File(path);
        if (!file2.isAbsolute() && currentDirectory != null) {
            file2 = new File(currentDirectory, path);
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/ApplicationStarterBase", "getFile"));
        }
        return file3;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    @Nullable
    protected Project getProject() {
        return null;
    }
}

