/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByLine {
    @NotNull
    public static FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        indicator.checkCanceled();
        FairDiffIterable fairDiffIterable = ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), policy, indicator);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        return fairDiffIterable;
    }

    @NotNull
    public static List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (lines3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines3", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        indicator.checkCanceled();
        List<MergeRange> list2 = ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), ByLine.getLines(lines3, policy), policy, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        return list2;
    }

    @NotNull
    static FairDiffIterable doCompare(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes = ByLine.compareSmart(lines1, lines2, indicator);
            changes = ByLine.optimizeLineChunks(lines1, lines2, changes, indicator);
            FairDiffIterable fairDiffIterable = ByLine.expandRanges(lines1, lines2, changes);
            if (fairDiffIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "doCompare"));
            }
            return fairDiffIterable;
        }
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLine.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        FairDiffIterable fairDiffIterable = ByLine.correctChangesSecondStep(lines1, lines2, iwChanges);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        return fairDiffIterable;
    }

    @NotNull
    static List<MergeRange> doCompare(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull List<Line> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (lines3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines3", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        indicator.checkCanceled();
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = ByLine.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = ByLine.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLine.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLine.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLine.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLine.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLine.correctChangesSecondStep(lines2, lines3, iwChanges2);
        List<MergeRange> list2 = ComparisonMergeUtil.buildFair(iterable1, iterable2, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "doCompare"));
        }
        return list2;
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<Line> lines1, final @NotNull List<Line> lines2, final @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "correctChangesSecondStep"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "correctChangesSecondStep"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByLine", "correctChangesSecondStep"));
        }
        final DiffIterableUtil.ExpandChangeBuilder builder = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = 0;
            private int last2 = 0;

            public void run() {
                for (Range range : changes.iterateUnchanged()) {
                    int count = range.end1 - range.start1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        int index1 = range.start1 + i2;
                        int index2 = range.start2 + i2;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)line1.getContent())) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(changes.getLength1(), changes.getLength2());
            }

            private void flush(int line1, int line2) {
                int i2;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, builder.getIndex1());
                int start2 = Math.max(this.last2, builder.getIndex2());
                TIntArrayList subLines1 = new TIntArrayList();
                TIntArrayList subLines2 = new TIntArrayList();
                for (i2 = start1; i2 < line1; ++i2) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines1.get(i2)).getContent())) continue;
                    subLines1.add(i2);
                    this.last1 = i2 + 1;
                }
                for (i2 = start2; i2 < line2; ++i2) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines2.get(i2)).getContent())) continue;
                    subLines2.add(i2);
                    this.last2 = i2 + 1;
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching(subLines1, subLines2);
                this.sample = null;
            }

            private void alignExactMatching(TIntArrayList subLines1, TIntArrayList subLines2) {
                boolean skipAligning;
                int n2 = Math.max(subLines1.size(), subLines2.size());
                boolean bl = skipAligning = n2 > 10 || subLines1.size() == subLines2.size();
                if (skipAligning) {
                    int count = Math.min(subLines1.size(), subLines2.size());
                    for (int i2 = 0; i2 < count; ++i2) {
                        int index1 = subLines1.get(i2);
                        int index2 = subLines2.get(i2);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i3 = 0; i3 < subLines1.size(); ++i3) {
                        int index1 = subLines1.get(i3);
                        int index2 = subLines2.get(matching[i3]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i4 = 0; i4 < subLines2.size(); ++i4) {
                        int index1 = subLines1.get(matching[i4]);
                        int index2 = subLines2.get(i4);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "correctChangesSecondStep"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static int[] getBestMatchingAlignment(final @NotNull TIntArrayList subLines1, final @NotNull TIntArrayList subLines2, final @NotNull List<Line> lines1, final @NotNull List<Line> lines2) {
        if (subLines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subLines1", "com/intellij/diff/comparison/ByLine", "getBestMatchingAlignment"));
        }
        if (subLines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subLines2", "com/intellij/diff/comparison/ByLine", "getBestMatchingAlignment"));
        }
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "getBestMatchingAlignment"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "getBestMatchingAlignment"));
        }
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            best[i2] = i2;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start2, int n2, int k2) {
                if (k2 == size) {
                    this.processCombination();
                    return;
                }
                for (int i2 = start2; i2 <= n2; ++i2) {
                    comb[k2] = i2;
                    this.combinations(i2 + 1, n2, k2 + 1);
                }
            }

            private void processCombination() {
                int weight = 0;
                for (int i2 = 0; i2 < size; ++i2) {
                    int index1 = subLines1.get(i2);
                    int index2 = subLines2.get(comb[i2]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight;
                }
                if (weight > this.bestWeight) {
                    this.bestWeight = weight;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        if (best == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getBestMatchingAlignment"));
        }
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "optimizeLineChunks"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "optimizeLineChunks"));
        }
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/ByLine", "optimizeLineChunks"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "optimizeLineChunks"));
        }
        FairDiffIterable fairDiffIterable = new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "optimizeLineChunks"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull ProgressIndicator indicator) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        int threshold = ComparisonUtil.getUnimportantLineCharCount();
        if (threshold == 0) {
            FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(lines1, lines2, indicator);
            if (fairDiffIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareSmart"));
            }
            return fairDiffIterable;
        }
        Pair<List<Line>, TIntArrayList> bigLines1 = ByLine.getBigLines(lines1, threshold);
        Pair<List<Line>, TIntArrayList> bigLines2 = ByLine.getBigLines(lines2, threshold);
        FairDiffIterable changes = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        FairDiffIterable fairDiffIterable = new ChangeCorrector.SmartLineChangeCorrector((TIntArrayList)bigLines1.second, (TIntArrayList)bigLines2.second, lines1, lines2, changes, indicator).build();
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static Pair<List<Line>, TIntArrayList> getBigLines(@NotNull List<Line> lines, int threshold) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ByLine", "getBigLines"));
        }
        ArrayList<Line> bigLines = new ArrayList<Line>(lines.size());
        TIntArrayList indexes = new TIntArrayList(lines.size());
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            Line line = lines.get(i2);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i2);
        }
        Pair pair = Pair.create(bigLines, (Object)indexes);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getBigLines"));
        }
        return pair;
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable iterable) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "expandRanges"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "expandRanges"));
        }
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/ByLine", "expandRanges"));
        }
        ArrayList<Range> changes = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes.add(expanded);
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.create(changes, lines1.size(), lines2.size()));
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "expandRanges"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static List<Line> getLines(@NotNull List<? extends CharSequence> text2, @NotNull ComparisonPolicy policy) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        List list2 = ContainerUtil.map(text2, line -> {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "lambda$getLines$0"));
            }
            return new Line((CharSequence)line, policy);
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        return list2;
    }

    @NotNull
    private static List<Line> convertMode(@NotNull List<Line> original, @NotNull ComparisonPolicy policy) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/comparison/ByLine", "convertMode"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "convertMode"));
        }
        ArrayList<Line> result2 = new ArrayList<Line>(original.size());
        for (Line line : original) {
            result2.add(new Line(line.getContent(), policy));
        }
        ArrayList<Line> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "convertMode"));
        }
        return arrayList;
    }

    static class Line {
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final ComparisonPolicy myPolicy;
        private final int myHash;
        private final int myNonSpaceChars;

        public Line(@NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "<init>"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine$Line", "<init>"));
            }
            this.myText = text2;
            this.myPolicy = policy;
            this.myHash = Line.hashCode(text2, policy);
            this.myNonSpaceChars = Line.countNonSpaceChars(text2);
        }

        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine$Line", "getContent"));
            }
            return charSequence;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Line line = (Line)o2;
            assert (this.myPolicy == line.myPolicy);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return Line.equals(this.getContent(), line.getContent(), this.myPolicy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static int countNonSpaceChars(@NotNull CharSequence text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "countNonSpaceChars"));
            }
            int nonSpace = 0;
            int len = text2.length();
            for (int offset = 0; offset < len; ++offset) {
                char c2 = text2.charAt(offset);
                if (StringUtil.isWhiteSpace((char)c2)) continue;
                ++nonSpace;
            }
            return nonSpace;
        }

        private static boolean equals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByLine$Line", "equals"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByLine$Line", "equals"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine$Line", "equals"));
            }
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
                }
                case TRIM_WHITESPACES: {
                    return StringUtil.equalsTrimWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
            }
            throw new IllegalArgumentException(policy.toString());
        }

        private static int hashCode(@NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "hashCode"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine$Line", "hashCode"));
            }
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.stringHashCode((CharSequence)text2);
                }
                case TRIM_WHITESPACES: {
                    int offset1 = TrimUtil.trimStart(text2, 0, text2.length());
                    int offset2 = TrimUtil.trimEnd(text2, offset1, text2.length());
                    return StringUtil.stringHashCode((CharSequence)text2, (int)offset1, (int)offset2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)text2);
                }
            }
            throw new IllegalArgumentException(policy.name());
        }
    }
}

