/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonManagerImpl
extends ComparisonManager {
    private static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        ComparisonManagerImpl comparisonManagerImpl = (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
        if (comparisonManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getInstanceImpl"));
        }
        return comparisonManagerImpl;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return list2;
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List<Line> lines3 = ComparisonManagerImpl.getLines(text3);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        List lineTexts3 = ContainerUtil.map(lines3, Line::getContent);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List<MergeLineFragment> list2 = ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return list2;
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lineFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        ArrayList<LineFragment> result2 = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            assert (fragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result2.addAll(ComparisonManagerImpl.createInnerFragments(fragment, text1, text2, policy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e2) {
                result2.add(fragment);
                ++tooBigChunksCount;
            }
        }
        return result2;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEquals(subSequence1, subSequence2, policy)) {
                List<LineFragmentImpl> list2 = Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
                }
                return list2;
            }
            List<LineFragment> list3 = Collections.singletonList(fragment);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
            }
            return list3;
        }
        if (!tryComputeDifferences) {
            List<LineFragment> list4 = Collections.singletonList(fragment);
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
            }
            return list4;
        }
        List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (lineBlocks.size() != 0);
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i2 = 0; i2 < lineBlocks.size(); ++i2) {
            ByWord.LineBlock block = lineBlocks.get(i2);
            Range offsets = block.offsets;
            int currentEndLine1 = i2 != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i2 != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        ArrayList<LineFragment> arrayList = chunks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "createInnerFragments"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (lineFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> list2 = this.compareLinesInner(text1, text2, policy, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        List<DiffFragment> list2 = ByWord.compare(text1, text2, policy, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            List<DiffFragment> list2 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list2;
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            List<DiffFragment> list3 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list3;
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        List<DiffFragment> list4 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        return list4;
    }

    @NotNull
    public List<Range> compareLines(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        FairDiffIterable iterable = ByLine.compare(lines1, lines2, policy, indicator);
        ArrayList arrayList = ContainerUtil.newArrayList(iterable.iterateChanges());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return arrayList;
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoDiffFragments"));
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoDiffFragments"));
        }
        return arrayList;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, ch.start1, ch.end1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        return arrayList;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull List<Line> lines, int startIndex, int endIndex) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lines.size() ? lines.get(startIndex).getOffset1() : lines.get(lines.size() - 1).getOffset2();
            IntPair intPair = new IntPair(offset, offset);
            if (intPair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
            }
            return intPair;
        }
        int offset1 = lines.get(startIndex).getOffset1();
        int offset2 = lines.get(endIndex - 1).getOffset2();
        IntPair intPair = new IntPair(offset1, offset2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
        }
        return intPair;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeLineFragments"));
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeLineFragments"));
        }
        return list2;
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeWordFragments"));
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeWordFragments"));
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
            }
            return list2;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (!squash && !trim) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list2;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list3 = oldFragments;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list3;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim));
        }));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer2) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int startIndex = 0;
        for (int i2 = 1; i2 < oldFragments.size(); ++i2) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i2 - 1), oldFragments.get(i2))) continue;
            consumer2.consume(oldFragments.subList(startIndex, i2));
            startIndex = i2;
        }
        if (startIndex < oldFragments.size()) {
            consumer2.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start2;
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start2 = 0; start2 < end; ++start2) {
                fragment = fragments.get(start2);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start2 < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start2 == end) {
            List<LineFragment> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list2;
        }
        if (squash) {
            List<LineFragment> list3 = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start2, end)));
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list3;
        }
        List<LineFragment> list4 = fragments.subList(start2, end);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        return list4;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
        if (lineFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        return lineFragmentImpl;
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        if (lineFragment.getInnerFragments() != null) {
            List list2 = lineFragment.getInnerFragments();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
            }
            return list2;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list3 = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        return list3;
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text2) {
        int lineEnd;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ComparisonManagerImpl", "getLines"));
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        int offset = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text2, (char)'\n', (int)offset)) != -1) {
            lines.add(new Line(text2, offset, lineEnd, true));
            offset = lineEnd + 1;
        }
        lines.add(new Line(text2, offset, text2.length(), false));
        ArrayList<Line> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getLines"));
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<TextRange> ignoredRanges1, @NotNull List<TextRange> ignoredRanges2, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        if (ignoredRanges1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRanges1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        if (ignoredRanges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRanges2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        BitSet ignored1 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges1);
        BitSet ignored2 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges2);
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, line -> line.getNotIgnoredContent(ignored1));
        List lineTexts2 = ContainerUtil.map(lines2, line -> line.getNotIgnoredContent(ignored2));
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
        if (innerFragments) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, indicator);
        }
        List list2 = ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredChanges(fragment, lines1, lines2, ignored1, ignored2));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesWithIgnoredRanges"));
        }
        return list2;
    }

    @NotNull
    private static BitSet collectIgnoredRanges(@NotNull List<TextRange> ignoredRanges) {
        if (ignoredRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRanges", "com/intellij/diff/comparison/ComparisonManagerImpl", "collectIgnoredRanges"));
        }
        BitSet set2 = new BitSet();
        for (TextRange range : ignoredRanges) {
            set2.set(range.getStartOffset(), range.getEndOffset());
        }
        BitSet bitSet = set2;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "collectIgnoredRanges"));
        }
        return bitSet;
    }

    @Nullable
    private static LineFragment trimIgnoredChanges(@NotNull LineFragment fragment, @NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredChanges"));
        }
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredChanges"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredChanges"));
        }
        if (ignored1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored1", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredChanges"));
        }
        if (ignored2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored2", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredChanges"));
        }
        Range range = TrimUtil.trimExpandList(lines1, lines2, fragment.getStartLine1(), fragment.getStartLine2(), fragment.getEndLine1(), fragment.getEndLine2(), (line1, line2) -> {
            if (ignored1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$7"));
            }
            if (ignored2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$7"));
            }
            return ComparisonManagerImpl.areIgnoredEqualLines(line1, line2, ignored1, ignored2);
        }, line -> {
            if (ignored1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$8"));
            }
            return ComparisonManagerImpl.isIgnoredLine(line, ignored1);
        }, line -> {
            if (ignored2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$9"));
            }
            return ComparisonManagerImpl.isIgnoredLine(line, ignored2);
        });
        int startLine1 = range.start1;
        int startLine2 = range.start2;
        int endLine1 = range.end1;
        int endLine2 = range.end2;
        if (startLine1 == endLine1 && startLine2 == endLine2) {
            return null;
        }
        IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, startLine1, endLine1);
        IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, startLine2, endLine2);
        int startOffset1 = offsets1.val1;
        int endOffset1 = offsets1.val2;
        int startOffset2 = offsets2.val1;
        int endOffset2 = offsets2.val2;
        List newInner = null;
        if (fragment.getInnerFragments() != null) {
            int shift1 = startOffset1 - fragment.getStartOffset1();
            int shift2 = startOffset2 - fragment.getStartOffset2();
            int newCount1 = endOffset1 - startOffset1;
            int newCount2 = endOffset2 - startOffset2;
            newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
                if (ignored1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$10"));
                }
                if (ignored2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$trimIgnoredChanges$10"));
                }
                int start1 = DiffUtil.bound(it.getStartOffset1() - shift1, 0, newCount1);
                int start2 = DiffUtil.bound(it.getStartOffset2() - shift2, 0, newCount2);
                int end1 = DiffUtil.bound(it.getEndOffset1() - shift1, 0, newCount1);
                int end2 = DiffUtil.bound(it.getEndOffset2() - shift2, 0, newCount2);
                TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(start1, end1, ignored1, startOffset1);
                TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(start2, end2, ignored2, startOffset2);
                if (range1.isEmpty() && range2.isEmpty()) {
                    return null;
                }
                return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
            });
            if (newInner.isEmpty()) {
                return null;
            }
        }
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, newInner);
    }

    private static boolean isIgnoredLine(@NotNull Line line, @NotNull BitSet ignored) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/diff/comparison/ComparisonManagerImpl", "isIgnoredLine"));
        }
        if (ignored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/diff/comparison/ComparisonManagerImpl", "isIgnoredLine"));
        }
        return ComparisonManagerImpl.trimIgnoredRange(line.getOffset1(), line.getOffset2(), ignored, 0).isEmpty();
    }

    private static boolean areIgnoredEqualLines(@NotNull Line line1, @NotNull Line line2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (line1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line1", "com/intellij/diff/comparison/ComparisonManagerImpl", "areIgnoredEqualLines"));
        }
        if (line2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line2", "com/intellij/diff/comparison/ComparisonManagerImpl", "areIgnoredEqualLines"));
        }
        if (ignored1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored1", "com/intellij/diff/comparison/ComparisonManagerImpl", "areIgnoredEqualLines"));
        }
        if (ignored2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored2", "com/intellij/diff/comparison/ComparisonManagerImpl", "areIgnoredEqualLines"));
        }
        int start1 = line1.getOffset1();
        int end1 = line1.getOffset2();
        int start2 = line2.getOffset1();
        int end2 = line2.getOffset2();
        Range range = TrimUtil.trimExpandText(line1.getOriginalText(), line2.getOriginalText(), start1, start2, end1, end2, ignored1, ignored2);
        return range.isEmpty();
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start2, int end, @NotNull BitSet ignored, int offset) {
        if (ignored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredRange"));
        }
        IntPair intPair = TrimUtil.trim(offset + start2, offset + end, ignored);
        TextRange textRange = new TextRange(intPair.val1 - offset, intPair.val2 - offset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "trimIgnoredRange"));
        }
        return textRange;
    }

    private static class Line {
        @NotNull
        private final CharSequence myChars;
        private final int myOffset1;
        private final int myOffset2;
        private final boolean myNewline;

        public Line(@NotNull CharSequence chars, int offset1, int offset2, boolean newline) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "<init>"));
            }
            this.myChars = chars;
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myNewline = newline;
        }

        public int getOffset1() {
            return this.myOffset1;
        }

        public int getOffset2() {
            return this.myOffset2 + (this.myNewline ? 1 : 0);
        }

        @NotNull
        public CharSequence getContent() {
            CharSequenceSubSequence charSequenceSubSequence = new CharSequenceSubSequence(this.myChars, this.myOffset1, this.myOffset2);
            if (charSequenceSubSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "getContent"));
            }
            return charSequenceSubSequence;
        }

        @NotNull
        public CharSequence getNotIgnoredContent(@NotNull BitSet ignored) {
            if (ignored == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "getNotIgnoredContent"));
            }
            StringBuilder sb2 = new StringBuilder();
            for (int i2 = this.myOffset1; i2 < this.myOffset2; ++i2) {
                if (ignored.get(i2)) continue;
                sb2.append(this.myChars.charAt(i2));
            }
            String string2 = sb2.toString();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "getNotIgnoredContent"));
            }
            return string2;
        }

        @NotNull
        public CharSequence getOriginalText() {
            CharSequence charSequence = this.myChars;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "getOriginalText"));
            }
            return charSequence;
        }
    }
}

