/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileContentImpl", "<init>"));
        }
        this(project2, file2, file2);
    }

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileContentImpl", "<init>"));
        }
        assert (file2.isValid() && !file2.isDirectory());
        this.myFile = file2;
        this.myProject = project2;
        this.myType = file2.getFileType();
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.myHighlightFile)) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getContentType"));
        }
        return fileType;
    }

    @NotNull
    public String getFilePath() {
        String string2 = this.myFile.getPath();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getFilePath"));
        }
        return string2;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

