/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        this(project2, document, file2, file2);
    }

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        super(project2, document, file2.getFileType(), highlightFile, FileDocumentContentImpl.getSeparator(file2), file2.getCharset(), file2.getBOM() != null);
        this.myFile = file2;
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "getSeparator"));
        }
        String s2 = LoadTextUtil.detectLineSeparator(file2, true);
        if (s2 == null) {
            return null;
        }
        return LineSeparator.fromString((String)s2);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileDocumentContentImpl", "getFile"));
        }
        return virtualFile;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

