/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestChainProcessor
extends CacheDiffRequestProcessor<DiffRequestProducer> {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestChainProcessor.class);
    @NotNull
    private final DiffRequestChain myRequestChain;

    public CacheDiffRequestChainProcessor(@Nullable Project project2, @NotNull DiffRequestChain requestChain) {
        if (requestChain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestChain", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "<init>"));
        }
        super(project2, (UserDataHolder)requestChain);
        this.myRequestChain = requestChain;
    }

    @Override
    @NotNull
    protected String getRequestName(@NotNull DiffRequestProducer producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getRequestName"));
        }
        String string2 = producer.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getRequestName"));
        }
        return string2;
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        List requests = this.myRequestChain.getRequests();
        int index = this.myRequestChain.getIndex();
        if (index < 0 || index >= requests.size()) {
            return null;
        }
        return (DiffRequestProducer)requests.get(index);
    }

    @Override
    @NotNull
    protected DiffRequest loadRequest(@NotNull DiffRequestProducer producer, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        DiffRequest diffRequest = producer.process((UserDataHolder)this.getContext(), indicator);
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        return diffRequest;
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        DiffRequestChain diffRequestChain = this.myRequestChain;
        if (diffRequestChain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getRequestChain"));
        }
        return diffRequestChain;
    }

    @Override
    @NotNull
    protected List<AnAction> getNavigationActions() {
        List list2 = ContainerUtil.list((Object[])new AnAction[]{new DiffRequestProcessor.MyPrevDifferenceAction(this), new DiffRequestProcessor.MyNextDifferenceAction(this), new DiffRequestProcessor.MyPrevChangeAction(this), new DiffRequestProcessor.MyNextChangeAction(this), this.createGoToChangeAction()});
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getNavigationActions"));
        }
        return list2;
    }

    @Override
    protected boolean hasNextChange() {
        return this.myRequestChain.getIndex() < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange() {
        return this.myRequestChain.getIndex() > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() + 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() - 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @NotNull
    private AnAction createGoToChangeAction() {
        AnAction anAction = GoToChangePopupBuilder.create(this.myRequestChain, (Consumer<Integer>)((Consumer)index -> {
            if (index >= 0 && index.intValue() != this.myRequestChain.getIndex()) {
                this.myRequestChain.setIndex(index.intValue());
                this.updateRequest();
            }
        }));
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "createGoToChangeAction"));
        }
        return anAction;
    }
}

