/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestProcessor<T>
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestProcessor.class);
    @NotNull
    private final SoftHardCacheMap<T, DiffRequest> myRequestCache;
    @NotNull
    private final DiffTaskQueue myQueue;

    public CacheDiffRequestProcessor(@Nullable Project project2) {
        super(project2);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project2, @NotNull String place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/diff/impl/CacheDiffRequestProcessor", "<init>"));
        }
        super(project2, place);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project2, @NotNull UserDataHolder context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/impl/CacheDiffRequestProcessor", "<init>"));
        }
        super(project2, context2);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    @Nullable
    protected abstract String getRequestName(@NotNull T var1);

    protected abstract T getCurrentRequestProvider();

    @NotNull
    protected abstract DiffRequest loadRequest(@NotNull T var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException, DiffRequestProducerException;

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    public void updateRequest(boolean force, boolean useCache, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        DiffRequest cachedRequest;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        T requestProvider = this.getCurrentRequestProvider();
        if (requestProvider == null) {
            this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, force, scrollToChangePolicy);
            return;
        }
        DiffRequest diffRequest = cachedRequest = useCache ? this.loadRequestFast(requestProvider) : null;
        if (cachedRequest != null) {
            this.applyRequest(cachedRequest, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait((Function<ProgressIndicator, Runnable>)((Function)indicator -> {
            DiffRequest request2 = this.doLoadRequest(requestProvider, (ProgressIndicator)indicator);
            return () -> {
                this.myRequestCache.put(requestProvider, request2);
                this.applyRequest(request2, force, scrollToChangePolicy);
            };
        }), () -> this.applyRequest((DiffRequest)new LoadingDiffRequest(this.getRequestName(requestProvider)), force, scrollToChangePolicy), 300L);
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull T provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/impl/CacheDiffRequestProcessor", "loadRequestFast"));
        }
        return this.myRequestCache.get(provider);
    }

    @NotNull
    private DiffRequest doLoadRequest(@NotNull T provider, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
        }
        String name = this.getRequestName(provider);
        try {
            diffRequest = this.loadRequest(provider, indicator);
        }
        catch (ProcessCanceledException e2) {
            OperationCanceledDiffRequest request2 = new OperationCanceledDiffRequest(name);
            request2.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(provider)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request2;
            if (operationCanceledDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e3) {
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(name, (Throwable)e3);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
            }
            return errorDiffRequest;
        }
        catch (Exception e4) {
            LOG.warn((Throwable)e4);
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(name, (Throwable)e4);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
            }
            return errorDiffRequest;
        }
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestProcessor", "doLoadRequest"));
        }
        return diffRequest;
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final T myProducer;

        public ReloadRequestAction(T provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/impl/CacheDiffRequestProcessor$ReloadRequestAction", "<init>"));
            }
            super("Reload", null, AllIcons.Actions.Refresh);
            this.myProducer = provider;
        }

        public void actionPerformed(AnActionEvent e2) {
            CacheDiffRequestProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestProcessor.this.updateRequest(true);
        }
    }
}

