/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LangDiffIgnoredRangeProvider
implements DiffIgnoredRangeProvider {
    protected abstract boolean accepts(@NotNull Project var1, @NotNull Language var2);

    @NotNull
    protected abstract List<TextRange> computeIgnoredRanges(@NotNull Project var1, @NotNull CharSequence var2, @NotNull Language var3);

    @Override
    public final boolean accepts(@Nullable Project project2, @NotNull DiffContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "accepts"));
        }
        if (project2 == null) {
            return false;
        }
        Language language = LangDiffIgnoredRangeProvider.getLanguage(project2, content2);
        if (language == null) {
            return false;
        }
        return this.accepts(project2, language);
    }

    @Override
    @NotNull
    public List<TextRange> getIgnoredRanges(@Nullable Project project2, @NotNull CharSequence text2, @NotNull DiffContent content2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "getIgnoredRanges"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "getIgnoredRanges"));
        }
        assert (project2 != null);
        Language language = LangDiffIgnoredRangeProvider.getLanguage(project2, content2);
        assert (language != null);
        List<TextRange> list2 = this.computeIgnoredRanges(project2, text2, language);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "getIgnoredRanges"));
        }
        return list2;
    }

    @Nullable
    private static Language getLanguage(@NotNull Project project2, @NotNull DiffContent content2) {
        VirtualFile highlightFile;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "getLanguage"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/lang/LangDiffIgnoredRangeProvider", "getLanguage"));
        }
        Language language = (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE);
        if (language != null) {
            return language;
        }
        FileType type = content2.getContentType();
        if (type instanceof LanguageFileType) {
            language = ((LanguageFileType)type).getLanguage();
        }
        if (language != null && content2 instanceof DocumentContent && (highlightFile = ((DocumentContent)content2).getHighlightFile()) != null) {
            language = LanguageSubstitutors.INSTANCE.substituteLanguage(language, highlightFile, project2);
        }
        return language;
    }
}

