/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeTool
implements MergeTool {
    public static final BinaryMergeTool INSTANCE = new BinaryMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context2, @NotNull MergeRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        BinaryMergeViewer binaryMergeViewer = new BinaryMergeViewer(context2, (ThreesideMergeRequest)request2);
        if (binaryMergeViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        return binaryMergeViewer;
    }

    public boolean canShow(@NotNull MergeContext context2, @NotNull MergeRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool", "canShow"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool", "canShow"));
        }
        if (!(request2 instanceof ThreesideMergeRequest)) {
            return false;
        }
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(context2);
        for (DiffContent diffContent : ((ThreesideMergeRequest)request2).getContents()) {
            if (BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE.canShowContent(diffContent, diffContext)) continue;
            return false;
        }
        return true;
    }

    public static class BinaryMergeViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ThreesideMergeRequest myMergeRequest;
        @NotNull
        private final DiffContext myDiffContext;
        @NotNull
        private final ContentDiffRequest myDiffRequest;
        @NotNull
        private final MyThreesideViewer myViewer;

        public BinaryMergeViewer(@NotNull MergeContext context2, @NotNull ThreesideMergeRequest request2) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "<init>"));
            }
            if (request2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "<init>"));
            }
            this.myMergeContext = context2;
            this.myMergeRequest = request2;
            this.myDiffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            this.myDiffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), BinaryMergeViewer.getDiffContents(this.myMergeRequest), BinaryMergeViewer.getDiffContentTitles(this.myMergeRequest));
            this.myViewer = new MyThreesideViewer(this.myDiffContext, (DiffRequest)this.myDiffRequest);
        }

        @NotNull
        private static List<DiffContent> getDiffContents(@NotNull ThreesideMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContents"));
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)mergeRequest.getContents());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContents"));
            }
            return arrayList;
        }

        @NotNull
        private static List<String> getDiffContentTitles(@NotNull ThreesideMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContentTitles"));
            }
            List<String> list2 = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContentTitles"));
            }
            return list2;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myViewer.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getComponent"));
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
            components.statusPanel = init2.statusPanel;
            components.toolbarActions = init2.toolbarActions;
            components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext);
            MergeTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(@NotNull MergeResult result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getResolveAction"));
            }
            if (result2 == MergeResult.RESOLVED) {
                return null;
            }
            return MergeUtil.createSimpleResolveAction(result2, (MergeRequest)this.myMergeRequest, this.myMergeContext, this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @NotNull
        public MyThreesideViewer getViewer() {
            MyThreesideViewer myThreesideViewer = this.myViewer;
            if (myThreesideViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getViewer"));
            }
            return myThreesideViewer;
        }

        private static class MyThreesideViewer
        extends ThreesideBinaryDiffViewer {
            public MyThreesideViewer(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer$MyThreesideViewer", "<init>"));
                }
                if (request2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer$MyThreesideViewer", "<init>"));
                }
                super(context2, request2);
            }

            @Override
            public void rediff(boolean trySync) {
            }
        }
    }
}

